/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizsample0003name',
          prop: 'ibizsample0003name',
          dataType: 'TEXT',
        },
        {
          name: 'memo',
          prop: 'memo',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'updateman',
          prop: 'updateman',
          dataType: 'TEXT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'pibizsample0003id',
          prop: 'pibizsample0003id',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizsample0003name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizsample0003id',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizsample0003id',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'ibizsample0003id',
          prop: 'ibizsample0003id',
          dataType: 'GUID',
        },
        {
          name: 'pibizsample0003name',
          prop: 'pibizsample0003name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'ibizsample0003',
          prop: 'ibizsample0003id',
        },
      {
        name: 'n_ibizsample0003name_like',
        prop: 'n_ibizsample0003name_like',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}