import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZBOOKService from '@/service/ibizbook/ibizbook-service';
import StateFieldGuideModel from './state-field-guide-wizardpanel-model';


/**
 * StateFieldGuide 部件服务对象
 *
 * @export
 * @class StateFieldGuideService
 */
export default class StateFieldGuideService extends ControlService {

    /**
     * 图书服务对象
     *
     * @type {IBIZBOOKService}
     * @memberof StateFieldGuideService
     */
    public appEntityService: IBIZBOOKService = new IBIZBOOKService({ $store: this.getStore() });

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof StateFieldGuideService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of StateFieldGuideService.
     * 
     * @param {*} [opts={}]
     * @memberof StateFieldGuideService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new StateFieldGuideModel();
    }

    /**
     * 初始化向导
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof StateFieldGuideService
     */
    @Errorlog
    public init(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Create(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }

    /**
     * 向导结束
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof StateFieldGuideService
     */
    @Errorlog
    public finish(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data);
        return new Promise((resolve: any, reject: any) => {
            let result: Promise<any>;
            const _appEntityService: any = this.appEntityService;
            // 忽略版本检查
            Object.assign(Data,{ignoreversioncheck:1});
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            } else {
                result = this.appEntityService.Update(Context,Data, isloading);
            }
            result.then((response) => {
                this.handleResponse(action, response);
                resolve(response);
            }).catch(response => {
                reject(response);
            });
        });
    }
}