/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizuniproductid',
          prop: 'ibizuniproductid',
          dataType: 'GUID',
        },
        {
          name: 'unit',
          prop: 'unit',
          dataType: 'TEXT',
        },
        {
          name: 'ibizuniproductname',
          prop: 'ibizuniproductname',
          dataType: 'TEXT',
        },
        {
          name: 'unitprice',
          prop: 'unitprice',
          dataType: 'FLOAT',
        },
        {
          name: 'ibizuniproducttype',
          prop: 'ibizuniproducttype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizuniproductname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdatatype',
          prop: 'ibizuniproducttype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizuniproductid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizuniproductid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'ibizuniproduct',
          prop: 'ibizuniproductid',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}