/**
 * 面板成员模型
 *
 * @export
 * @class PanelDetailModel
 */
export class PanelDetailModel {

    /**
     * 成员标题
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public caption: string = '';

    /**
     * 成员类型
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public itemType: string = '';

    /**
     * 面板对象
     *
     * @type {*}
     * @memberof PanelDetailModel
     */
    public panel: any = null;

    /**
     * 成员名称
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public name: string = '';

    /**
     * 成员是否显示
     *
     * @type {boolean}
     * @memberof PanelDetailModel
     */
    public visible: boolean = true;

    /**
     * 布局模式
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public layout: string = '';

    /**
     *  布局占位（边缘布局使用）
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public layoutPos: string = '';

    /**
     * 布局高度
     *
     * @type {number}
     * @memberof PanelDetailModel
     */
    public layoutHeight: number = 0;

    /**
     * 高度模式
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public heightMode: string = '';

    /**
     * 布局宽度
     *
     * @type {number}
     * @memberof PanelDetailModel
     */
    public layoutWidth: number = 0;

    /**
     * 宽度模式
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public widthMode: string = '';

    /**
     * 下档间隔
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public spacingBottom: string = '';

    /**
     * 左侧间隔
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public spacingLeft: string = '';

    /**
     * 右侧间隔
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public spacingRight: string = '';

    /**
     * 顶部间隔
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public spacingTop: string = '';

    /**
     * 自身水平对齐模式
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public hAlignSelf: string = '';

    /**
     * 自身垂直对齐模式
     *
     * @type {string}
     * @memberof PanelDetailModel
     */
    public vAlignSelf: string = '';

    /**
     * Flex延伸
     *
     * @type {number}
     * @memberof PanelDetailModel
     */
    public flexGrow: number = 0;

    /**
     * Creates an instance of PanelDetailModel.
     * PanelDetailModel 实例
     * 
     * @param {*} [opts={}]
     * @memberof PanelDetailModel
     */
    constructor(opts: any = {}) {
        this.caption = opts.caption;
        this.itemType = opts.itemType;
        this.panel = opts.panel;
        this.name = opts.name;
        this.visible = opts.visible;
        this.layout = opts.layout;
        this.layoutPos = opts.layoutPos;
        this.layoutHeight = opts.layoutHeight;
        this.heightMode = opts.heightMode;
        this.layoutWidth = opts.layoutWidth;
        this.widthMode = opts.widthMode;
        this.spacingBottom = opts.spacingBottom;
        this.spacingLeft = opts.spacingLeft;
        this.spacingRight = opts.spacingRight;
        this.spacingTop = opts.spacingTop;
        this.hAlignSelf = opts.hAlignSelf;
        this.vAlignSelf = opts.vAlignSelf;
        this.flexGrow = opts.flexGrow;
    }

}