package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0008;
import cn.ibizlab.core.sample.service.IIBIZSample0008Service;
import cn.ibizlab.core.sample.filter.IBIZSample0008SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"自循环流程" })
@RestController("DemoAPI-ibizsample0008")
@RequestMapping("")
public class IBIZSample0008Resource {

    @Autowired
    public IIBIZSample0008Service ibizsample0008Service;

    @Autowired
    @Lazy
    public IBIZSample0008Mapping ibizsample0008Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0008Mapping.toDomain(#ibizsample0008dto),'DemoSys-IBIZSample0008-Create')")
    @ApiOperation(value = "新建自循环流程", tags = {"自循环流程" },  notes = "新建自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0008s")
    public ResponseEntity<IBIZSample0008DTO> create(@Validated @RequestBody IBIZSample0008DTO ibizsample0008dto) {
        IBIZSample0008 domain = ibizsample0008Mapping.toDomain(ibizsample0008dto);
		ibizsample0008Service.create(domain);
        IBIZSample0008DTO dto = ibizsample0008Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0008Mapping.toDomain(#ibizsample0008dtos),'DemoSys-IBIZSample0008-Create')")
    @ApiOperation(value = "批量新建自循环流程", tags = {"自循环流程" },  notes = "批量新建自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0008s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0008DTO> ibizsample0008dtos) {
        ibizsample0008Service.createBatch(ibizsample0008Mapping.toDomain(ibizsample0008dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0008Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0008-Get')")
    @ApiOperation(value = "获取自循环流程", tags = {"自循环流程" },  notes = "获取自循环流程")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0008s/{ibizsample0008_id}")
    public ResponseEntity<IBIZSample0008DTO> get(@PathVariable("ibizsample0008_id") String ibizsample0008_id) {
        IBIZSample0008 domain = ibizsample0008Service.get(ibizsample0008_id);
        IBIZSample0008DTO dto = ibizsample0008Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0008Service.get(#ibizsample0008_id),'DemoSys-IBIZSample0008-Remove')")
    @ApiOperation(value = "删除自循环流程", tags = {"自循环流程" },  notes = "删除自循环流程")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0008s/{ibizsample0008_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0008_id") String ibizsample0008_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0008Service.remove(ibizsample0008_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0008Service.getIbizsample0008ByIds(#ids),'DemoSys-IBIZSample0008-Remove')")
    @ApiOperation(value = "批量删除自循环流程", tags = {"自循环流程" },  notes = "批量删除自循环流程")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0008s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0008Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0008" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0008Service.get(#ibizsample0008_id),'DemoSys-IBIZSample0008-Update')")
    @ApiOperation(value = "更新自循环流程", tags = {"自循环流程" },  notes = "更新自循环流程")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0008s/{ibizsample0008_id}")
    public ResponseEntity<IBIZSample0008DTO> update(@PathVariable("ibizsample0008_id") String ibizsample0008_id, @RequestBody IBIZSample0008DTO ibizsample0008dto) {
		IBIZSample0008 domain  = ibizsample0008Mapping.toDomain(ibizsample0008dto);
        domain .setIbizsample0008id(ibizsample0008_id);
		ibizsample0008Service.update(domain );
		IBIZSample0008DTO dto = ibizsample0008Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0008Service.getIbizsample0008ByEntities(this.ibizsample0008Mapping.toDomain(#ibizsample0008dtos)),'DemoSys-IBIZSample0008-Update')")
    @ApiOperation(value = "批量更新自循环流程", tags = {"自循环流程" },  notes = "批量更新自循环流程")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0008s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0008DTO> ibizsample0008dtos) {
        ibizsample0008Service.updateBatch(ibizsample0008Mapping.toDomain(ibizsample0008dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查自循环流程", tags = {"自循环流程" },  notes = "检查自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0008s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0008DTO ibizsample0008dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0008Service.checkKey(ibizsample0008Mapping.toDomain(ibizsample0008dto)));
    }

    @ApiOperation(value = "获取自循环流程草稿", tags = {"自循环流程" },  notes = "获取自循环流程草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0008s/getdraft")
    public ResponseEntity<IBIZSample0008DTO> getDraft(IBIZSample0008DTO dto) {
        IBIZSample0008 domain = ibizsample0008Mapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0008Mapping.toDto(ibizsample0008Service.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0008Mapping.toDomain(#ibizsample0008dto),'DemoSys-IBIZSample0008-Save')")
    @ApiOperation(value = "保存自循环流程", tags = {"自循环流程" },  notes = "保存自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0008s/save")
    public ResponseEntity<IBIZSample0008DTO> save(@RequestBody IBIZSample0008DTO ibizsample0008dto) {
        IBIZSample0008 domain = ibizsample0008Mapping.toDomain(ibizsample0008dto);
        ibizsample0008Service.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0008Mapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizsample0008Mapping.toDomain(#ibizsample0008dtos),'DemoSys-IBIZSample0008-Save')")
    @ApiOperation(value = "批量保存自循环流程", tags = {"自循环流程" },  notes = "批量保存自循环流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0008s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0008DTO> ibizsample0008dtos) {
        ibizsample0008Service.saveBatch(ibizsample0008Mapping.toDomain(ibizsample0008dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0008-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"自循环流程" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0008s/fetchdefault")
	public ResponseEntity<List<IBIZSample0008DTO>> fetchDefault(IBIZSample0008SearchContext context) {
        Page<IBIZSample0008> domains = ibizsample0008Service.searchDefault(context) ;
        List<IBIZSample0008DTO> list = ibizsample0008Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0008-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0008-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"自循环流程" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0008s/searchdefault")
	public ResponseEntity<Page<IBIZSample0008DTO>> searchDefault(@RequestBody IBIZSample0008SearchContext context) {
        Page<IBIZSample0008> domains = ibizsample0008Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0008Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

