package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZBOOKDTO]
 */
@Data
@ApiModel("图书")
public class IBIZBOOKDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [IBIZBOOKNAME]
     *
     */
    @JSONField(name = "ibizbookname")
    @JsonProperty("ibizbookname")
    @NotBlank(message = "[图书名称]不允许为空!")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("图书名称")
    private String ibizbookname;

    /**
     * 属性 [IBIZBOOKID]
     *
     */
    @JSONField(name = "ibizbookid")
    @JsonProperty("ibizbookid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("图书标识")
    private String ibizbookid;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [AUTHOR]
     *
     */
    @JSONField(name = "author")
    @JsonProperty("author")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("图书作者")
    private String author;

    /**
     * 属性 [PRICE]
     *
     */
    @JSONField(name = "price")
    @JsonProperty("price")
    @ApiModelProperty("图书价格")
    private Double price;

    /**
     * 属性 [PRESS]
     *
     */
    @JSONField(name = "press")
    @JsonProperty("press")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("图书出版社")
    private String press;

    /**
     * 属性 [TYPE]
     *
     */
    @JSONField(name = "type")
    @JsonProperty("type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("图书类型")
    private String type;

    /**
     * 属性 [BOOKNUMBER]
     *
     */
    @JSONField(name = "booknumber")
    @JsonProperty("booknumber")
    @ApiModelProperty("图书数量")
    private Integer booknumber;

    /**
     * 属性 [SUBTEXT]
     *
     */
    @JSONField(name = "subtext")
    @JsonProperty("subtext")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("图书描述")
    private String subtext;

    /**
     * 属性 [LENDOUTTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "lendouttime" , format="yyyy-MM-dd")
    @JsonProperty("lendouttime")
    @NotNull(message = "[借出日期]不允许为空!")
    @ApiModelProperty("借出日期")
    private Timestamp lendouttime;

    /**
     * 属性 [RETURNTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "returntime" , format="yyyy-MM-dd")
    @JsonProperty("returntime")
    @NotNull(message = "[归还日期]不允许为空!")
    @ApiModelProperty("归还日期")
    private Timestamp returntime;

    /**
     * 属性 [ICON]
     *
     */
    @JSONField(name = "icon")
    @JsonProperty("icon")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("图标")
    private String icon;

    /**
     * 属性 [SAILSTATE]
     *
     */
    @JSONField(name = "sailstate")
    @JsonProperty("sailstate")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("图书销售状态")
    private String sailstate;

    /**
     * 属性 [BORROWSTATUS]
     *
     */
    @JSONField(name = "borrowstatus")
    @JsonProperty("borrowstatus")
    @ApiModelProperty("图书借阅状态")
    private Integer borrowstatus;

    /**
     * 属性 [STEPSTATUS]
     *
     */
    @JSONField(name = "stepstatus")
    @JsonProperty("stepstatus")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("步骤")
    private String stepstatus;

    /**
     * 属性 [BORROWER]
     *
     */
    @JSONField(name = "borrower")
    @JsonProperty("borrower")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("借阅人")
    private String borrower;

    /**
     * 属性 [BORROWWAY]
     *
     */
    @JSONField(name = "borrowway")
    @JsonProperty("borrowway")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("借阅方式")
    private String borrowway;

    /**
     * 属性 [RETURNLIB]
     *
     */
    @JSONField(name = "returnlib")
    @JsonProperty("returnlib")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("归还图馆")
    private String returnlib;

    /**
     * 属性 [BORROWERID]
     *
     */
    @JSONField(name = "borrowerid")
    @JsonProperty("borrowerid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("借阅人ID")
    private String borrowerid;

    /**
     * 属性 [BORROWER1]
     *
     */
    @JSONField(name = "borrower1")
    @JsonProperty("borrower1")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("借阅人1")
    private String borrower1;

    /**
     * 属性 [BORROWER1_ID]
     *
     */
    @JSONField(name = "borrower1_id")
    @JsonProperty("borrower1_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("借阅人1_ID")
    private String borrower1Id;

    /**
     * 属性 [BORROWER2]
     *
     */
    @JSONField(name = "borrower2")
    @JsonProperty("borrower2")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("借阅人2")
    private String borrower2;

    /**
     * 属性 [BORROWER2_ID]
     *
     */
    @JSONField(name = "borrower2_id")
    @JsonProperty("borrower2_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("借阅人2_ID")
    private String borrower2Id;

    /**
     * 属性 [BORROWER3]
     *
     */
    @JSONField(name = "borrower3")
    @JsonProperty("borrower3")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("借阅人3")
    private String borrower3;

    /**
     * 属性 [BORROWER3_ID]
     *
     */
    @JSONField(name = "borrower3_id")
    @JsonProperty("borrower3_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("借阅人3_ID")
    private String borrower3Id;

    /**
     * 属性 [TAG]
     *
     */
    @JSONField(name = "tag")
    @JsonProperty("tag")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("标签")
    private String tag;


    /**
     * 设置 [IBIZBOOKNAME]
     */
    public void setIbizbookname(String  ibizbookname){
        this.ibizbookname = ibizbookname ;
        this.modify("ibizbookname",ibizbookname);
    }

    /**
     * 设置 [AUTHOR]
     */
    public void setAuthor(String  author){
        this.author = author ;
        this.modify("author",author);
    }

    /**
     * 设置 [PRICE]
     */
    public void setPrice(Double  price){
        this.price = price ;
        this.modify("price",price);
    }

    /**
     * 设置 [PRESS]
     */
    public void setPress(String  press){
        this.press = press ;
        this.modify("press",press);
    }

    /**
     * 设置 [TYPE]
     */
    public void setType(String  type){
        this.type = type ;
        this.modify("type",type);
    }

    /**
     * 设置 [BOOKNUMBER]
     */
    public void setBooknumber(Integer  booknumber){
        this.booknumber = booknumber ;
        this.modify("booknumber",booknumber);
    }

    /**
     * 设置 [SUBTEXT]
     */
    public void setSubtext(String  subtext){
        this.subtext = subtext ;
        this.modify("subtext",subtext);
    }

    /**
     * 设置 [LENDOUTTIME]
     */
    public void setLendouttime(Timestamp  lendouttime){
        this.lendouttime = lendouttime ;
        this.modify("lendouttime",lendouttime);
    }

    /**
     * 设置 [RETURNTIME]
     */
    public void setReturntime(Timestamp  returntime){
        this.returntime = returntime ;
        this.modify("returntime",returntime);
    }

    /**
     * 设置 [ICON]
     */
    public void setIcon(String  icon){
        this.icon = icon ;
        this.modify("icon",icon);
    }

    /**
     * 设置 [SAILSTATE]
     */
    public void setSailstate(String  sailstate){
        this.sailstate = sailstate ;
        this.modify("sailstate",sailstate);
    }

    /**
     * 设置 [BORROWSTATUS]
     */
    public void setBorrowstatus(Integer  borrowstatus){
        this.borrowstatus = borrowstatus ;
        this.modify("borrowstatus",borrowstatus);
    }

    /**
     * 设置 [STEPSTATUS]
     */
    public void setStepstatus(String  stepstatus){
        this.stepstatus = stepstatus ;
        this.modify("stepstatus",stepstatus);
    }

    /**
     * 设置 [BORROWER]
     */
    public void setBorrower(String  borrower){
        this.borrower = borrower ;
        this.modify("borrower",borrower);
    }

    /**
     * 设置 [BORROWWAY]
     */
    public void setBorrowway(String  borrowway){
        this.borrowway = borrowway ;
        this.modify("borrowway",borrowway);
    }

    /**
     * 设置 [RETURNLIB]
     */
    public void setReturnlib(String  returnlib){
        this.returnlib = returnlib ;
        this.modify("returnlib",returnlib);
    }

    /**
     * 设置 [BORROWERID]
     */
    public void setBorrowerid(String  borrowerid){
        this.borrowerid = borrowerid ;
        this.modify("borrowerid",borrowerid);
    }

    /**
     * 设置 [BORROWER1]
     */
    public void setBorrower1(String  borrower1){
        this.borrower1 = borrower1 ;
        this.modify("borrower1",borrower1);
    }

    /**
     * 设置 [BORROWER1_ID]
     */
    public void setBorrower1Id(String  borrower1Id){
        this.borrower1Id = borrower1Id ;
        this.modify("borrower1_id",borrower1Id);
    }

    /**
     * 设置 [BORROWER2]
     */
    public void setBorrower2(String  borrower2){
        this.borrower2 = borrower2 ;
        this.modify("borrower2",borrower2);
    }

    /**
     * 设置 [BORROWER2_ID]
     */
    public void setBorrower2Id(String  borrower2Id){
        this.borrower2Id = borrower2Id ;
        this.modify("borrower2_id",borrower2Id);
    }

    /**
     * 设置 [BORROWER3]
     */
    public void setBorrower3(String  borrower3){
        this.borrower3 = borrower3 ;
        this.modify("borrower3",borrower3);
    }

    /**
     * 设置 [BORROWER3_ID]
     */
    public void setBorrower3Id(String  borrower3Id){
        this.borrower3Id = borrower3Id ;
        this.modify("borrower3_id",borrower3Id);
    }

    /**
     * 设置 [TAG]
     */
    public void setTag(String  tag){
        this.tag = tag ;
        this.modify("tag",tag);
    }


}


