package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZCustomerMGDTO]
 */
@Data
@ApiModel("客户管理")
public class IBIZCustomerMGDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZCUSTOMERID]
     *
     */
    @JSONField(name = "ibizcustomerid")
    @JsonProperty("ibizcustomerid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("客户标识")
    private String ibizcustomerid;

    /**
     * 属性 [IBIZCUSTOMERNAME]
     *
     */
    @JSONField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("客户名称")
    private String ibizcustomername;

    /**
     * 属性 [BANKACCOUNTNUM]
     *
     */
    @JSONField(name = "bankaccountnum")
    @JsonProperty("bankaccountnum")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("开户银行号")
    private String bankaccountnum;

    /**
     * 属性 [BANKNAME]
     *
     */
    @JSONField(name = "bankname")
    @JsonProperty("bankname")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("开户行")
    private String bankname;

    /**
     * 属性 [ADDRESS]
     *
     */
    @JSONField(name = "address")
    @JsonProperty("address")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("公司地址")
    private String address;

    /**
     * 属性 [CUSTOMERUID]
     *
     */
    @JSONField(name = "customeruid")
    @JsonProperty("customeruid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("客户编号")
    private String customeruid;



}


