import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZAPPEDITORService from '@/service/ibizappeditor/ibizappeditor-service';
import EditorChartModel from './editor-chart-chart-model';


/**
 * EditorChart 部件服务对象
 *
 * @export
 * @class EditorChartService
 */
export default class EditorChartService extends ControlService {

    /**
     * 编辑器服务对象
     *
     * @type {IBIZAPPEDITORService}
     * @memberof EditorChartService
     */
    public appEntityService: IBIZAPPEDITORService = new IBIZAPPEDITORService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof EditorChartService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of EditorChartService.
     * 
     * @param {*} [opts={}]
     * @memberof EditorChartService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new EditorChartModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EditorChartService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}