import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 任务服务对象基类
 *
 * @export
 * @class IBIZTASKServiceBase
 * @extends {EntityServie}
 */
export default class IBIZTASKServiceBase extends EntityService {

    /**
     * Creates an instance of  IBIZTASKServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZTASKServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof IBIZTASKServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='ibiztask';
        this.APPDEKEY = 'ibiztaskid';
        this.APPDENAME = 'ibiztasks';
        this.APPDETEXT = 'ibiztaskname';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'demosys';
    }

// 实体接口

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibiztasks/${context.ibiztask}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let ibiztaskteamsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_ibiztaskteams'),'undefined')){
            ibiztaskteamsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_ibiztaskteams') as any);
            if(ibiztaskteamsData && ibiztaskteamsData.length && ibiztaskteamsData.length > 0){
                ibiztaskteamsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.ibiztaskteamid = null;
                            if(item.hasOwnProperty('ibiztaskid') && item.ibiztaskid) item.ibiztaskid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.ibiztaskteams = ibiztaskteamsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/ibiztasks`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_ibiztaskteams',JSON.stringify(res.data.ibiztaskteams?res.data.ibiztaskteams:[]));
        
        return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibiztasks/${context.ibiztask}`,isloading);
                        this.tempStorage.setItem(context.srfsessionkey+'_ibiztaskteams',JSON.stringify(res.data.ibiztaskteams?res.data.ibiztaskteams:[]));

            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/ibiztasks/getdraft`,isloading);
        res.data.ibiztask = data.ibiztask;
                    this.tempStorage.setItem(context.srfsessionkey+'_ibiztaskteams',JSON.stringify(res.data.ibiztaskteams?res.data.ibiztaskteams:[]));

        return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/ibiztasks/${context.ibiztask}`,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let ibiztaskteamsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_ibiztaskteams'),'undefined')){
            ibiztaskteamsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_ibiztaskteams') as any);
            if(ibiztaskteamsData && ibiztaskteamsData.length && ibiztaskteamsData.length > 0){
                ibiztaskteamsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.ibiztaskteamid = null;
                            if(item.hasOwnProperty('ibiztaskid') && item.ibiztaskid) item.ibiztaskid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.ibiztaskteams = ibiztaskteamsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/ibiztasks/${context.ibiztask}/save`,data,isloading);
                        this.tempStorage.setItem(context.srfsessionkey+'_ibiztaskteams',JSON.stringify(res.data.ibiztaskteams?res.data.ibiztaskteams:[]));

            return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let ibiztaskteamsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_ibiztaskteams'),'undefined')){
            ibiztaskteamsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_ibiztaskteams') as any);
            if(ibiztaskteamsData && ibiztaskteamsData.length && ibiztaskteamsData.length > 0){
                ibiztaskteamsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.ibiztaskteamid = null;
                            if(item.hasOwnProperty('ibiztaskid') && item.ibiztaskid) item.ibiztaskid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.ibiztaskteams = ibiztaskteamsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/ibiztasks/${context.ibiztask}`,data,isloading);
                        this.tempStorage.setItem(context.srfsessionkey+'_ibiztaskteams',JSON.stringify(res.data.ibiztaskteams?res.data.ibiztaskteams:[]));

            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibiztasks/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibiztasks/searchdefault`,tempData,isloading);
    }

    /**
     * FetchTempDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async FetchTempDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
    }

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZTASKServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().get(`/ibiztasks/${context.ibiztask}/select`,isloading);
            
            return res;
    }
}