import { MockAdapter } from '../mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'

// 获取全部数组
mock.onGet('./assets/json/data-dictionary.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status, [
        {
        srfkey: "AppCtrlType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "form",
                label: "表单类",
                text: "表单类",
                "class":"",
                "data":"",
                "codename":"Form",
                value: "form",
                
                disabled: false,
            },
            {
                id: "navigation",
                label: "导航类",
                text: "导航类",
                "class":"",
                "data":"",
                "codename":"Navigation",
                value: "navigation",
                
                disabled: false,
            },
            {
                id: "panel",
                label: "面板类",
                text: "面板类",
                "class":"",
                "data":"",
                "codename":"Panel",
                value: "panel",
                
                disabled: false,
            },
            {
                id: "multidata",
                label: "多数据类",
                text: "多数据类",
                "class":"",
                "data":"",
                "codename":"Multidata",
                value: "multidata",
                
                disabled: false,
            },
            {
                id: "other",
                label: "其他类",
                text: "其他类",
                "class":"",
                "data":"",
                "codename":"Other",
                value: "other",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "AppEditorType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "basics",
                label: "基础类",
                text: "基础类",
                "class":"",
                "data":"",
                "codename":"Basics",
                value: "basics",
                
                disabled: false,
            },
            {
                id: "exhibition",
                label: "展示类",
                text: "展示类",
                "class":"",
                "data":"",
                "codename":"Exhibition",
                value: "exhibition",
                
                disabled: false,
            },
            {
                id: "choose",
                label: "选择类",
                text: "选择类",
                "class":"",
                "data":"",
                "codename":"Choose",
                value: "choose",
                
                disabled: false,
            },
            {
                id: "datachoose",
                label: "数据选择类",
                text: "数据选择类",
                "class":"",
                "data":"",
                "codename":"Datachoose",
                value: "datachoose",
                
                disabled: false,
            },
            {
                id: "datechoose",
                label: "时间选择类",
                text: "时间选择类",
                "class":"",
                "data":"",
                "codename":"Datechoose",
                value: "datechoose",
                
                disabled: false,
            },
            {
                id: "fileupload",
                label: "文件上传类",
                text: "文件上传类",
                "class":"",
                "data":"",
                "codename":"Fileupload",
                value: "fileupload",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "AppViewType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "singledataview",
                label: "单数据视图",
                text: "单数据视图",
                "class":"",
                "data":"",
                "codename":"Singledataview",
                value: "singledataview",
                
                disabled: false,
            },
            {
                id: "multidataview",
                label: "多数据视图",
                text: "多数据视图",
                "class":"",
                "data":"",
                "codename":"Multidataview",
                value: "multidataview",
                
                disabled: false,
            },
            {
                id: "navigationview",
                label: "导航视图",
                text: "导航视图",
                "class":"",
                "data":"",
                "codename":"Navigationview",
                value: "navigationview",
                
                disabled: false,
            },
            {
                id: "chooseview",
                label: "选择视图",
                text: "选择视图",
                "class":"",
                "data":"",
                "codename":"Chooseview",
                value: "chooseview",
                
                disabled: false,
            },
            {
                id: "workflowview",
                label: "工作流视图",
                text: "工作流视图",
                "class":"",
                "data":"",
                "codename":"Workflowview",
                value: "workflowview",
                
                disabled: false,
            },
            {
                id: "applicationview",
                label: "应用视图",
                text: "应用视图",
                "class":"",
                "data":"",
                "codename":"Applicationview",
                value: "applicationview",
                
                disabled: false,
            },
            {
                id: "functionalview",
                label: "功能视图",
                text: "功能视图",
                "class":"",
                "data":"",
                "codename":"Functionalview",
                value: "functionalview",
                
                disabled: false,
            },
            {
                id: "otherview",
                label: "其他视图",
                text: "其他视图",
                "class":"",
                "data":"",
                "codename":"Otherview",
                value: "otherview",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "BOOKSTATUSGUIDE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "step1",
                label: "step1",
                text: "step1",
                "class":"",
                "data":"",
                "codename":"Step1",
                value: "step1",
                
                disabled: false,
            },
            {
                id: "step2",
                label: "step2",
                text: "step2",
                "class":"",
                "data":"",
                "codename":"Step2",
                value: "step2",
                
                disabled: false,
            },
            {
                id: "step3",
                label: "step3",
                text: "step3",
                "class":"",
                "data":"",
                "codename":"Step3",
                value: "step3",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "BookSailState",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "100",
                label: "未出版",
                text: "未出版",
                "class":"",
                "data":"",
                "codename":"Item_100",
                value: "100",
                
                disabled: false,
            },
            {
                id: "200",
                label: "等待出版",
                text: "等待出版",
                "class":"",
                "data":"",
                "codename":"Item_200",
                value: "200",
                
                disabled: false,
            },
            {
                id: "300",
                label: "未上架",
                text: "未上架",
                "class":"",
                "data":"",
                "codename":"Item_300",
                value: "300",
                
                disabled: false,
            },
            {
                id: "400",
                label: "已上架",
                text: "已上架",
                "class":"",
                "data":"",
                "codename":"Item_400",
                value: "400",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "BookType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "仙侠",
                label: "仙侠",
                text: "仙侠",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "仙侠",
                
                disabled: false,
            },
            {
                id: "武侠",
                label: "武侠",
                text: "武侠",
                "class":"",
                "data":"",
                "codename":"Item_2",
                value: "武侠",
                
                disabled: false,
            },
            {
                id: "玄幻",
                label: "玄幻",
                text: "玄幻",
                "class":"",
                "data":"",
                "codename":"Item_3",
                value: "玄幻",
                
                disabled: false,
            },
            {
                id: "都市",
                label: "都市",
                text: "都市",
                "class":"",
                "data":"",
                "codename":"Item_4",
                value: "都市",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "Bookgroup",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "all",
                label: "全部",
                text: "全部",
                "class":"",
                "data":"",
                "codename":"All",
                value: "all",
                
                disabled: false,
            },
            {
                id: "onshelf",
                label: "已上架",
                text: "已上架",
                "class":"",
                "data":{"n_sailstate_eq":400},
                "codename":"Onshelf",
                value: "onshelf",
                
                disabled: false,
            },
            {
                id: "noshelf",
                label: "未上架",
                text: "未上架",
                "class":"",
                "data":{"n_sailstate_eq":300},
                "codename":"Noshelf",
                value: "noshelf",
                
                disabled: false,
            },
            {
                id: "other",
                label: "其他",
                text: "其他",
                "class":"",
                "data":"",
                "codename":"Other",
                value: "other",
                
                disabled: false,
            },
            {
                id: "nopublish",
                label: "未出版",
                text: "未出版",
                "class":"",
                "data":{"n_sailstate_eq":100},
                "codename":"Nopublish",
                value: "nopublish",
                "pvalue": "other",
                disabled: false,
            },
            {
                id: "waitpublish",
                label: "等待出版",
                text: "等待出版",
                "class":"",
                "data":{"n_sailstate_eq":200},
                "codename":"Waitpublish",
                value: "waitpublish",
                "pvalue": "other",
                disabled: false,
            },
        ]
    },
    {
        srfkey: "Booktag",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "历史",
                label: "历史",
                text: "历史",
                "class":"",
                "data":"",
                "codename":"History",
                value: "历史",
                
                disabled: false,
            },
            {
                id: "数学",
                label: "数学",
                text: "数学",
                "class":"",
                "data":"",
                "codename":"Math",
                value: "数学",
                
                disabled: false,
            },
            {
                id: "文学",
                label: "文学",
                text: "文学",
                "class":"",
                "data":"",
                "codename":"Literature",
                value: "文学",
                
                disabled: false,
            },
            {
                id: "科学",
                label: "科学",
                text: "科学",
                "class":"",
                "data":"",
                "codename":"Science",
                value: "科学",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CodeList",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "100",
                label: "第一图书馆",
                text: "第一图书馆",
                "class":"",
                "data":"",
                "codename":"Item_100",
                value: "100",
                
                disabled: false,
            },
            {
                id: "300",
                label: "第三图书馆",
                text: "第三图书馆",
                "class":"",
                "data":"",
                "codename":"Item_300",
                value: "300",
                
                disabled: false,
            },
            {
                id: "200",
                label: "第二图书馆",
                text: "第二图书馆",
                "class":"",
                "data":"",
                "codename":"Item_200",
                value: "200",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CodeList25",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "10",
                label: "押金",
                text: "押金",
                "class":"",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "身份证",
                text: "身份证",
                "class":"",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "学生证",
                text: "学生证",
                "class":"",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CodeList43",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "HTMLeditor",
                label: "HTML编辑器",
                text: "HTML编辑器",
                "class":"",
                "data":"",
                "codename":"Htmleditor",
                value: "HTMLeditor",
                
                disabled: false,
            },
            {
                id: "droplist",
                label: "下拉列表框",
                text: "下拉列表框",
                "class":"",
                "data":"",
                "codename":"Droplist",
                value: "droplist",
                
                disabled: false,
            },
            {
                id: "picturecontrol",
                label: "图片控件",
                text: "图片控件",
                "class":"",
                "data":"",
                "codename":"Picturecontrol",
                value: "picturecontrol",
                
                disabled: false,
            },
            {
                id: "textarea",
                label: "多行输入框",
                text: "多行输入框",
                "class":"",
                "data":"",
                "codename":"Textarea",
                value: "textarea",
                
                disabled: false,
            },
            {
                id: "picker",
                label: "数据选择",
                text: "数据选择",
                "class":"",
                "data":"",
                "codename":"Picker",
                value: "picker",
                
                disabled: false,
            },
            {
                id: "fileupload",
                label: "文件上传控件",
                text: "文件上传控件",
                "class":"",
                "data":"",
                "codename":"Fileupload",
                value: "fileupload",
                
                disabled: false,
            },
            {
                id: "textbox",
                label: "文本框",
                text: "文本框",
                "class":"",
                "data":"",
                "codename":"Textbox",
                value: "textbox",
                
                disabled: false,
            },
            {
                id: "label",
                label: "标签",
                text: "标签",
                "class":"",
                "data":"",
                "codename":"Label",
                value: "label",
                
                disabled: false,
            },
            {
                id: "userdefined",
                label: "用户自定义",
                text: "用户自定义",
                "class":"",
                "data":"",
                "codename":"Userdefined",
                value: "userdefined",
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "DYNAORDERTYPE",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"IBIZOrderType",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: "HARDWARETYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "Storage",
                label: "存储",
                text: "存储",
                "class":"",
                "data":"",
                "codename":"Storage",
                value: "Storage",
                
                disabled: false,
            },
            {
                id: "CPU",
                label: "处理器",
                text: "处理器",
                "class":"",
                "data":"",
                "codename":"Cpu",
                value: "CPU",
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORDERENTITYDATA",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"IBIZOrder",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: "ORDERSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "10",
                label: "未提交",
                text: "未提交",
                "class":"",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "审核中",
                text: "审核中",
                "class":"",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "已通过",
                text: "已通过",
                "class":"",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
            {
                id: "40",
                label: "未通过",
                text: "未通过",
                "class":"",
                "data":"",
                "codename":"Item_40",
                value: "40",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "ORDERSTEP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "发起人调整",
                text: "发起人调整",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "5",
                label: "部门经理审核",
                text: "部门经理审核",
                "class":"",
                "data":"",
                "codename":"Item_5",
                value: "5",
                
                disabled: false,
            },
            {
                id: "10",
                label: "财务经理审核",
                text: "财务经理审核",
                "class":"",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "总经理审核",
                text: "总经理审核",
                "class":"",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "财务总监审批",
                text: "财务总监审批",
                "class":"",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "OrderType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "已下单",
                text: "已下单",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "已取消",
                text: "已取消",
                "class":"",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "已完成",
                text: "已完成",
                "class":"",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "SCODELIST_NUM",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "类型1",
                text: "类型1",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: "2",
                label: "类型2",
                text: "类型2",
                "class":"",
                "data":"",
                "codename":"Item_2",
                value: 2,
                
                disabled: false,
            },
            {
                id: "4",
                label: "类型3",
                text: "类型3",
                "class":"",
                "data":"",
                "codename":"Item_4",
                value: 4,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "SCODELIST_TEXT",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "A",
                label: "类型1",
                text: "类型1",
                "class":"",
                "data":"",
                "codename":"A",
                value: "A",
                
                disabled: false,
            },
            {
                id: "B",
                label: "类型2",
                text: "类型2",
                "class":"",
                "data":"",
                "codename":"B",
                value: "B",
                
                disabled: false,
            },
            {
                id: "C",
                label: "类型3",
                text: "类型3",
                "class":"",
                "data":"",
                "codename":"C",
                value: "C",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "S_OrderType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "10",
                label: "销售订单",
                text: "销售订单",
                "class":"",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "采购订单",
                text: "采购订单",
                "class":"",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "生产订单",
                text: "生产订单",
                "class":"",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "SysOperator",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"",
        "appdedataset":"",
        "items": []
    },
    {
        srfkey: "UNIPRODUCTTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "Software",
                label: "软件",
                text: "软件",
                "class":"",
                "data":"",
                "codename":"Software",
                value: "Software",
                
                disabled: false,
            },
            {
                id: "Hardware",
                label: "硬件",
                text: "硬件",
                "class":"",
                "data":"",
                "codename":"Hardware",
                value: "Hardware",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "WFStates",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未启动",
                text: "未启动",
                "class":"",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
            {
                id: "1",
                label: "流程中",
                text: "流程中",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "已完成",
                text: "已完成",
                "class":"",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "已取消",
                text: "已取消",
                "class":"",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
            {
                id: "31",
                label: "已取消(人工)",
                text: "已取消(人工)",
                "class":"",
                "data":"",
                "codename":"Item_31",
                value: "31",
                
                disabled: false,
            },
            {
                id: "32",
                label: "已取消(超时)",
                text: "已取消(超时)",
                "class":"",
                "data":"",
                "codename":"Item_32",
                value: "32",
                
                disabled: false,
            },
            {
                id: "4",
                label: "处理故障",
                text: "处理故障",
                "class":"",
                "data":"",
                "codename":"Item_4",
                value: "4",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "YesNo",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "是",
                text: "是",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "0",
                label: "否",
                text: "否",
                "class":"",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
        ]
    }
    ]];
});

