import ViewMessageService from '../view-message-service';
/**
 * 默认数据类型视图消息服务对象基类
 *
 * @export
 * @class ViewMsgMessageServiceBase
 */
export default class ViewMsgMessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsgMessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsgMessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsgMessageServiceBase
     */
    public initBasicParam(){
        this.id = "17e0a3ad74be124e3e5ccb2fcf3c0e9f";
        this.name = "默认数据类型";
        this.codename = "ViewMsg";
        this.title = "";
        this.content = "本示例展示实体属性数据类型的默认呈现组件。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsgMessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}