import ViewMessageService from '../view-message-service';
/**
 * 列表内置功能视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsg9MessageServiceBase
 */
export default class ViewMsg9MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg9MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg9MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg9MessageServiceBase
     */
    public initBasicParam(){
        this.id = "f99aa686fb0051be8732f8390f5c52f3";
        this.name = "列表内置功能视图消息";
        this.codename = "ViewMsg9";
        this.title = "";
        this.content = "本示例展示列表的内置功能：包含快速搜索表单部件、快速分组、搜索栏、搜索表单部件、加载更多。具体需求参数参考文档。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg9MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}