import ViewMessageService from '../view-message-service';
/**
 * 工作流启动视图消息服务对象基类
 *
 * @export
 * @class ViewMsg91MessageServiceBase
 */
export default class ViewMsg91MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg91MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg91MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg91MessageServiceBase
     */
    public initBasicParam(){
        this.id = "89820991c79ac896df5158b9c46186c9";
        this.name = "工作流启动";
        this.codename = "ViewMsg91";
        this.title = "";
        this.content = "本示例展示工作流启动：选中数据打开编辑视图，即可启动工作流。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg91MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}