import ViewMessageService from '../view-message-service';
/**
 * 嵌入导航视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg83MessageServiceBase
 */
export default class ViewMsg83MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg83MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg83MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg83MessageServiceBase
     */
    public initBasicParam(){
        this.id = "23366aa6d3ef606f2f7ccd21191473c7";
        this.name = "嵌入导航视图";
        this.codename = "ViewMsg83";
        this.title = "";
        this.content = "本示例展示嵌入导航视图：嵌入树导航视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg83MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}