import ViewMessageService from '../view-message-service';
/**
 * 数据视图主状态视图消息服务对象基类
 *
 * @export
 * @class ViewMsg61MessageServiceBase
 */
export default class ViewMsg61MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg61MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg61MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg61MessageServiceBase
     */
    public initBasicParam(){
        this.id = "66a8b4402c3bfb3567c529405536499c";
        this.name = "数据视图主状态";
        this.codename = "ViewMsg61";
        this.title = "";
        this.content = "本示例展示数据视图主状态（通过主状态控制操作项状态）：图书类型为都市时禁用编辑，类型为仙侠时禁用删除。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg61MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}