import ViewMessageService from '../view-message-service';
/**
 * 表格---列更新视图消息服务对象基类
 *
 * @export
 * @class ViewMsg41MessageServiceBase
 */
export default class ViewMsg41MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg41MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg41MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg41MessageServiceBase
     */
    public initBasicParam(){
        this.id = "8e4576f39d96338fd8001f7812d82f16";
        this.name = "表格---列更新";
        this.codename = "ViewMsg41";
        this.title = "";
        this.content = "本示例展示表格的列更新功能：图书类型值变化会对图书出版社表格列进行相应的更新。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg41MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}