import ViewMessageService from '../view-message-service';
/**
 * 分页导航视图消息服务对象基类
 *
 * @export
 * @class ViewMsg33MessageServiceBase
 */
export default class ViewMsg33MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg33MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg33MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg33MessageServiceBase
     */
    public initBasicParam(){
        this.id = "9e00b436ef31ed90aa336e6236cd85da";
        this.name = "分页导航";
        this.codename = "ViewMsg33";
        this.title = "";
        this.content = "本示例展示分页导航功能：分页导航实体可以在一个界面中定义多个视图进行查看，可以快速的查看与比较关联的数据。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg33MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}