import ViewMessageService from '../view-message-service';
/**
 * 默认编辑器类型视图消息服务对象基类
 *
 * @export
 * @class ViewMsg2MessageServiceBase
 */
export default class ViewMsg2MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg2MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg2MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg2MessageServiceBase
     */
    public initBasicParam(){
        this.id = "45e3ecbacdd4dcdf0b3eb5238320450d";
        this.name = "默认编辑器类型";
        this.codename = "ViewMsg2";
        this.title = "";
        this.content = "本示例展示各类编辑器的呈现样式。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg2MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}