import ViewMessageService from '../view-message-service';
/**
 * 表单-输入提示视图消息服务对象基类
 *
 * @export
 * @class ViewMsg21MessageServiceBase
 */
export default class ViewMsg21MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg21MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg21MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg21MessageServiceBase
     */
    public initBasicParam(){
        this.id = "41febba3e622fea499665f1c30ac26e2";
        this.name = "表单-输入提示";
        this.codename = "ViewMsg21";
        this.title = "";
        this.content = "本示例展示表单的输入提示功能：展示内容表单中部分控件的输入提示。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg21MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}