import ViewMessageService from '../view-message-service';
/**
 * 表单更新默认值视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg20MessageServiceBase
 */
export default class ViewMsg20MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg20MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg20MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg20MessageServiceBase
     */
    public initBasicParam(){
        this.id = "1819af51c37a686c4342d974df008eec";
        this.name = "表单更新默认值";
        this.codename = "ViewMsg20";
        this.title = "";
        this.content = "本示例展示表单的更新默认值功能：包含【订单时间】默认为【当前时间】、【订单状态】默认为【未提交】。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg20MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}