package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZCustomer_INTFDTO]
 */
@Data
public class IBIZCustomer_INTFDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [SN]
     *
     */
    @JSONField(name = "sn")
    @JsonProperty("sn")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String sn;

    /**
     * 属性 [CUSTOMERUID]
     *
     */
    @JSONField(name = "customeruid")
    @JsonProperty("customeruid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String customeruid;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String orgid;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [ADDRESS]
     *
     */
    @JSONField(name = "address")
    @JsonProperty("address")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String address;

    /**
     * 属性 [IBIZCUSTOMERNAME]
     *
     */
    @JSONField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizcustomername;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [IBIZCUSTOMERID]
     *
     */
    @JSONField(name = "ibizcustomerid")
    @JsonProperty("ibizcustomerid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizcustomerid;


    /**
     * 设置 [SN]
     */
    public void setSn(String  sn){
        this.sn = sn ;
        this.modify("sn",sn);
    }

    /**
     * 设置 [CUSTOMERUID]
     */
    public void setCustomeruid(String  customeruid){
        this.customeruid = customeruid ;
        this.modify("customeruid",customeruid);
    }

    /**
     * 设置 [ADDRESS]
     */
    public void setAddress(String  address){
        this.address = address ;
        this.modify("address",address);
    }

    /**
     * 设置 [IBIZCUSTOMERNAME]
     */
    public void setIbizcustomername(String  ibizcustomername){
        this.ibizcustomername = ibizcustomername ;
        this.modify("ibizcustomername",ibizcustomername);
    }


}


