import { MockAdapter } from '../mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'

// 获取全部数组
mock.onGet('./assets/json/data-dictionary.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status, [
        {
        "srfkey": "SysOperator",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"",
        "appdedataset":"",
        "items": []
    },
    {
        srfkey: "UNIPRODUCTTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "Software",
                label: "软件",
                text: "软件",
                "class":"",
                "data":"",
                "codename":"Software",
                value: "Software",
                
                disabled: false,
            },
            {
                id: "Hardware",
                label: "硬件",
                text: "硬件",
                "class":"",
                "data":"",
                "codename":"Hardware",
                value: "Hardware",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "SCODELIST_NUM",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "类型1",
                text: "类型1",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: "2",
                label: "类型2",
                text: "类型2",
                "class":"",
                "data":"",
                "codename":"Item_2",
                value: 2,
                
                disabled: false,
            },
            {
                id: "4",
                label: "类型3",
                text: "类型3",
                "class":"",
                "data":"",
                "codename":"Item_4",
                value: 4,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "Bookgroup",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "all",
                label: "全部",
                text: "全部",
                "class":"",
                "data":"",
                "codename":"All",
                value: "all",
                
                disabled: false,
            },
            {
                id: "onshelf",
                label: "已上架",
                text: "已上架",
                "class":"",
                "data":"",
                "codename":"Onshelf",
                value: "onshelf",
                
                disabled: false,
            },
            {
                id: "noshelf",
                label: "未上架",
                text: "未上架",
                "class":"",
                "data":"",
                "codename":"Noshelf",
                value: "noshelf",
                
                disabled: false,
            },
            {
                id: "other",
                label: "其他",
                text: "其他",
                "class":"",
                "data":"",
                "codename":"Other",
                value: "other",
                
                disabled: false,
            },
            {
                id: "nopublish",
                label: "未出版",
                text: "未出版",
                "class":"",
                "data":"",
                "codename":"Nopublish",
                value: "nopublish",
                "pvalue": "other",
                disabled: false,
            },
            {
                id: "waitpublish",
                label: "等待出版",
                text: "等待出版",
                "class":"",
                "data":"",
                "codename":"Waitpublish",
                value: "waitpublish",
                "pvalue": "other",
                disabled: false,
            },
        ]
    },
    {
        srfkey: "SCODELIST_TEXT",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "A",
                label: "类型1",
                text: "类型1",
                "class":"",
                "data":"",
                "codename":"A",
                value: "A",
                
                disabled: false,
            },
            {
                id: "B",
                label: "类型2",
                text: "类型2",
                "class":"",
                "data":"",
                "codename":"B",
                value: "B",
                
                disabled: false,
            },
            {
                id: "C",
                label: "类型3",
                text: "类型3",
                "class":"",
                "data":"",
                "codename":"C",
                value: "C",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "BookType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "仙侠",
                label: "仙侠",
                text: "仙侠",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "仙侠",
                
                disabled: false,
            },
            {
                id: "武侠",
                label: "武侠",
                text: "武侠",
                "class":"",
                "data":"",
                "codename":"Item_2",
                value: "武侠",
                
                disabled: false,
            },
            {
                id: "玄幻",
                label: "玄幻",
                text: "玄幻",
                "class":"",
                "data":"",
                "codename":"Item_3",
                value: "玄幻",
                
                disabled: false,
            },
            {
                id: "都市",
                label: "都市",
                text: "都市",
                "class":"",
                "data":"",
                "codename":"Item_4",
                value: "都市",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "YesNo",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "是",
                text: "是",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "0",
                label: "否",
                text: "否",
                "class":"",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "ORDERSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "10",
                label: "未提交",
                text: "未提交",
                "class":"",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "审核中",
                text: "审核中",
                "class":"",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "已通过",
                text: "已通过",
                "class":"",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
            {
                id: "40",
                label: "未通过",
                text: "未通过",
                "class":"",
                "data":"",
                "codename":"Item_40",
                value: "40",
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "ORDERTYPE",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"IBIZOrderType",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: "S_OrderType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "10",
                label: "销售订单",
                text: "销售订单",
                "class":"",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "采购订单",
                text: "采购订单",
                "class":"",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "生产订单",
                text: "生产订单",
                "class":"",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "OrderType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "已下单",
                text: "已下单",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "已取消",
                text: "已取消",
                "class":"",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "已完成",
                text: "已完成",
                "class":"",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
        ]
    }
    ]];
});

