// 基于 @CONTROL/数据图表/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZAPPVIEWService from '@/service/ibizappview/ibizappview-service';
import ViewChartModel from './view-chart-chart-model';


/**
 * ViewChart 部件服务对象
 *
 * @export
 * @class ViewChartService
 */
export default class ViewChartService extends ControlService {

    /**
     * 应用视图服务对象
     *
     * @type {IBIZAPPVIEWService}
     * @memberof ViewChartService
     */
    public appEntityService: IBIZAPPVIEWService = new IBIZAPPVIEWService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof ViewChartService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of ViewChartService.
     * 
     * @param {*} [opts={}]
     * @memberof ViewChartService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new ViewChartModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ViewChartService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}