// 基于 @CONTROL/搜索栏/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZOrderService from '@/service/ibizorder/ibizorder-service';
import SearchbarModel from './searchbar-searchbar-model';
import UtilService from '@/utilservice/util-service';


/**
 * Searchbar 部件服务对象
 *
 * @export
 * @class SearchbarService
 */
export default class SearchbarService extends ControlService {

    /**
     * 订单服务对象
     *
     * @type {IBIZOrderService}
     * @memberof SearchbarService
     */
    public appEntityService: IBIZOrderService = new IBIZOrderService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof SearchbarService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of SearchbarService.
     * 
     * @param {*} [opts={}]
     * @memberof SearchbarService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new SearchbarModel();
    }

    /**
     * 工具服务对象
     *
     * @protected
     * @type {UtilService}
     * @memberof SearchbarService
     */
    protected utilService: UtilService = new UtilService();

    /**
     * 加载数据模型
     *
     * @param {string} serviceName
     * @param {*} context
     * @param {*} viewparams
     * @memberof SearchbarService
     */
    public loadModel(serviceName: string, context: any, viewparams: any) {
        return new Promise((resolve: any, reject: any) => {
            this.utilService.getService(serviceName).then((service: any) => {
                service.loadModelData(JSON.stringify(context), viewparams).then((response: any) => {
                    resolve(response);
                }).catch((response: any) => {
                    reject(response);
                });
            }).catch((response: any) => {
                reject(response);
            });
        });
    }

    /**
     * 保存模型
     *
     * @param {string} serviceName
     * @param {*} context
     * @param {*} viewparams
     * @returns
     * @memberof SearchbarService
     */
    public saveModel(serviceName: string, context: any, viewparams: any) {
        return new Promise((resolve: any, reject: any) => {
            this.utilService.getService(serviceName).then((service: any) => {
                service.saveModelData(JSON.stringify(context), '', viewparams).then((response: any) => {
                    resolve(response);
                }).catch((response: any) => {
                    reject(response);
                });
            }).catch((response: any) => {
                reject(response);
            });
        });
    }

}