// 基于 @CONTROL/数据图表/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZAPPEXTENDEDITORService from '@/service/ibizappextendeditor/ibizappextendeditor-service';
import ExtendEditorChartModel from './extend-editor-chart-chart-model';


/**
 * ExtendEditorChart 部件服务对象
 *
 * @export
 * @class ExtendEditorChartService
 */
export default class ExtendEditorChartService extends ControlService {

    /**
     * 扩展编辑器服务对象
     *
     * @type {IBIZAPPEXTENDEDITORService}
     * @memberof ExtendEditorChartService
     */
    public appEntityService: IBIZAPPEXTENDEDITORService = new IBIZAPPEXTENDEDITORService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof ExtendEditorChartService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of ExtendEditorChartService.
     * 
     * @param {*} [opts={}]
     * @memberof ExtendEditorChartService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new ExtendEditorChartModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ExtendEditorChartService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}