// 基于 @CONTROL/数据图表/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZAPPCTRLService from '@/service/ibizappctrl/ibizappctrl-service';
import CtrlChartModel from './ctrl-chart-chart-model';


/**
 * CtrlChart 部件服务对象
 *
 * @export
 * @class CtrlChartService
 */
export default class CtrlChartService extends ControlService {

    /**
     * 应用部件服务对象
     *
     * @type {IBIZAPPCTRLService}
     * @memberof CtrlChartService
     */
    public appEntityService: IBIZAPPCTRLService = new IBIZAPPCTRLService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof CtrlChartService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of CtrlChartService.
     * 
     * @param {*} [opts={}]
     * @memberof CtrlChartService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new CtrlChartModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof CtrlChartService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}