import ViewMessageService from '../view-message-service';
/**
 * 日历主状态视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg63MessageServiceBase
 */
export default class ViewMsg63MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg63MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg63MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg63MessageServiceBase
     */
    public initBasicParam(){
        this.id = "56ed03bfd7be0d1eb915e1f49ceb2fb8";
        this.name = "日历主状态";
        this.codename = "ViewMsg63";
        this.title = "";
        this.content = "本示例展示日历主状态（通过主状态控制日历项上下文菜单状态）：图书类型为都市时禁用编辑，类型为仙侠时禁用删除，类型为武侠时禁用打开文档。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg63MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}