package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0002;
import cn.ibizlab.core.sample.service.IBIZSample0002Service;
import cn.ibizlab.core.sample.filter.IBIZSample0002SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体02" })
@RestController("demoapi-ibizsample0002")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0002Resource {

    @Autowired
    public IBIZSample0002Service ibizSample0002Service;

    @Autowired
    @Lazy
    public IBIZSample0002DTOMapping ibizSample0002DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"示例实体02" },  notes = "IBIZSample0002-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-Create-all') or hasPermission(this.ibizSample0002DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0002-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s")
    public ResponseEntity<IBIZSample0002DTO> create
            (@Validated @RequestBody IBIZSample0002DTO dto) {
        IBIZSample0002 domain = ibizSample0002DtoMapping.toDomain(dto);
        ibizSample0002Service.create(domain);
        IBIZSample0002 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0002DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"示例实体02" },  notes = "IBIZSample0002-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-Get-all') or hasPermission(this.ibizSample0002DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0002-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0002s/{ibizSample0002Id}")
    public ResponseEntity<IBIZSample0002DTO> getByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id) {
        IBIZSample0002 rt = ibizSample0002Service.get(ibizSample0002Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0002DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"示例实体02" },  notes = "IBIZSample0002-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-Remove-all') or hasPermission(this.ibizSample0002Service.get(#ibizSample0002Id),'DemoSys-IBIZSample0002-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0002s/{ibizSample0002Id}")
    public ResponseEntity<Boolean> removeByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id) {
        Boolean rt = ibizSample0002Service.remove(ibizSample0002Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"示例实体02" },  notes = "IBIZSample0002-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-Update-all') or hasPermission(this.ibizSample0002Service.get(#ibizSample0002Id),'DemoSys-IBIZSample0002-Update')")
    @VersionCheck(entity = "ibizsample0002" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0002s/{ibizSample0002Id}")
    public ResponseEntity<IBIZSample0002DTO> updateByIbizSample0002Id
            (@PathVariable("ibizSample0002Id") String ibizSample0002Id, @Validated @RequestBody IBIZSample0002DTO dto) {
        IBIZSample0002 domain = ibizSample0002DtoMapping.toDomain(dto);
        domain.setIbizSample0002Id(ibizSample0002Id);
        ibizSample0002Service.update(domain);
        IBIZSample0002 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0002DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"示例实体02" },  notes = "IBIZSample0002-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0002DTO dto) {
        IBIZSample0002 domain = ibizSample0002DtoMapping.toDomain(dto);
        Integer rt = ibizSample0002Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"示例实体02" },  notes = "IBIZSample0002-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0002s/getdraft")
    public ResponseEntity<IBIZSample0002DTO> getDraft
            (IBIZSample0002DTO dto) {
        IBIZSample0002 domain = ibizSample0002DtoMapping.toDomain(dto);
        IBIZSample0002 rt = ibizSample0002Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0002DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"示例实体02" },  notes = "IBIZSample0002-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-Save-all') or hasPermission(this.ibizSample0002DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0002-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/save")
    public ResponseEntity<IBIZSample0002DTO> save
            (@Validated @RequestBody IBIZSample0002DTO dto) {
        IBIZSample0002 domain = ibizSample0002DtoMapping.toDomain(dto);
        ibizSample0002Service.save(domain);
        IBIZSample0002 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0002DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"示例实体02" },  notes = "IBIZSample0002-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-searchDefault-all','DemoSys-IBIZSample0002-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0002-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0002s/fetchdefault")
    public ResponseEntity<List<IBIZSample0002DTO>> fetchDefault
            (IBIZSample0002SearchContext dto) {
        Page<IBIZSample0002> domains = ibizSample0002Service.searchDefault(dto) ;
        List<IBIZSample0002DTO> list = ibizSample0002DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0002-Create-all')")
    @ApiOperation(value = "批量新建示例实体02", tags = {"示例实体02" },  notes = "批量新建示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0002DTO> dtos) {
        ibizSample0002Service.createBatch(ibizSample0002DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0002-Update-all')")
    @ApiOperation(value = "批量更新示例实体02", tags = {"示例实体02" },  notes = "批量更新示例实体02")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0002s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0002DTO> dtos) {
        ibizSample0002Service.updateBatch(ibizSample0002DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0002-Save-all')")
    @ApiOperation(value = "批量保存示例实体02", tags = {"示例实体02" },  notes = "批量保存示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0002DTO> dtos) {
        ibizSample0002Service.saveBatch(ibizSample0002DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0002-Save-all')")
    @ApiOperation(value = "批量导入示例实体02", tags = {"示例实体02" },  notes = "批量导入示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0002s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0002DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0002> list=ibizSample0002DtoMapping.toDomain(dtos);
            List<IBIZSample0002> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0002Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0002-Remove-all')")
    @ApiOperation(value = "批量删除示例实体02", tags = {"示例实体02" },  notes = "批量删除示例实体02")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0002s","/ibizsample0002s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0002Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
