package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0018DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体18")
public class IBIZSample0018DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 描述
     */
    @JsonProperty("description")
    @JSONField(name = "description")
    @ApiModelProperty("描述")
    private String description;

    /**
     * 示例实体04标识
     */
    @JsonProperty("ibizsample0018id")
    @JSONField(name = "ibizsample0018id")
    @ApiModelProperty("示例实体04标识")
    private String ibizSample0018Id;

    /**
     * 示例实体04名称
     */
    @JsonProperty("ibizsample0018name")
    @JSONField(name = "ibizsample0018name")
    @ApiModelProperty("示例实体04名称")
    private String ibizSample0018Name;

    /**
     * 图片
     */
    @JsonProperty("image")
    @JSONField(name = "image")
    @ApiModelProperty("图片")
    private String image;

    /**
     * 序号
     */
    @JsonProperty("sn")
    @JSONField(name = "sn")
    @ApiModelProperty("序号")
    private Integer sn;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [描述]
     */
    public void setDescription(String description) {
        this.description = description;
        this.modify("description", description);
    }

    /**
     * 设置 [示例实体04名称]
     */
    public void setIbizSample0018Name(String ibizSample0018Name) {
        this.ibizSample0018Name = ibizSample0018Name;
        this.modify("ibizsample0018name", ibizSample0018Name);
    }

    /**
     * 设置 [图片]
     */
    public void setImage(String image) {
        this.image = image;
        this.modify("image", image);
    }

    /**
     * 设置 [序号]
     */
    public void setSn(Integer sn) {
        this.sn = sn;
        this.modify("sn", sn);
    }


}
