package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0020;
import cn.ibizlab.core.sample.service.IBIZSample0020Service;
import cn.ibizlab.core.sample.filter.IBIZSample0020SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"员工" })
@RestController("demoapi-ibizsample0020")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0020Resource {

    @Autowired
    public IBIZSample0020Service ibizSample0020Service;

    @Autowired
    @Lazy
    public IBIZSample0020DTOMapping ibizSample0020DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"员工" },  notes = "IBIZSample0020-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-Create-all') or hasPermission(this.ibizSample0020DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0020-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0020s")
    public ResponseEntity<IBIZSample0020DTO> create
            (@Validated @RequestBody IBIZSample0020DTO dto) {
        IBIZSample0020 domain = ibizSample0020DtoMapping.toDomain(dto);
        ibizSample0020Service.create(domain);
        IBIZSample0020 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0020DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"员工" },  notes = "IBIZSample0020-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-Get-all') or hasPermission(this.ibizSample0020DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0020-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0020s/{ibizsample0020Id}")
    public ResponseEntity<IBIZSample0020DTO> getByIbizsample0020Id
            (@PathVariable("ibizsample0020Id") String ibizsample0020Id) {
        IBIZSample0020 rt = ibizSample0020Service.get(ibizsample0020Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0020DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"员工" },  notes = "IBIZSample0020-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-Remove-all') or hasPermission(this.ibizSample0020Service.get(#ibizsample0020Id),'DemoSys-IBIZSample0020-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0020s/{ibizsample0020Id}")
    public ResponseEntity<Boolean> removeByIbizsample0020Id
            (@PathVariable("ibizsample0020Id") String ibizsample0020Id) {
        Boolean rt = ibizSample0020Service.remove(ibizsample0020Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"员工" },  notes = "IBIZSample0020-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-Update-all') or hasPermission(this.ibizSample0020Service.get(#ibizsample0020Id),'DemoSys-IBIZSample0020-Update')")
    @VersionCheck(entity = "ibizsample0020" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0020s/{ibizsample0020Id}")
    public ResponseEntity<IBIZSample0020DTO> updateByIbizsample0020Id
            (@PathVariable("ibizsample0020Id") String ibizsample0020Id, @Validated @RequestBody IBIZSample0020DTO dto) {
        IBIZSample0020 domain = ibizSample0020DtoMapping.toDomain(dto);
        domain.setIbizsample0020Id(ibizsample0020Id);
        ibizSample0020Service.update(domain);
        IBIZSample0020 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0020DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"员工" },  notes = "IBIZSample0020-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0020s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0020DTO dto) {
        IBIZSample0020 domain = ibizSample0020DtoMapping.toDomain(dto);
        Integer rt = ibizSample0020Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"员工" },  notes = "IBIZSample0020-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0020s/getdraft")
    public ResponseEntity<IBIZSample0020DTO> getDraft
            (IBIZSample0020DTO dto) {
        IBIZSample0020 domain = ibizSample0020DtoMapping.toDomain(dto);
        IBIZSample0020 rt = ibizSample0020Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0020DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"员工" },  notes = "IBIZSample0020-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-Save-all') or hasPermission(this.ibizSample0020DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0020-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0020s/save")
    public ResponseEntity<IBIZSample0020DTO> save
            (@Validated @RequestBody IBIZSample0020DTO dto) {
        IBIZSample0020 domain = ibizSample0020DtoMapping.toDomain(dto);
        ibizSample0020Service.save(domain);
        IBIZSample0020 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0020DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"员工" },  notes = "IBIZSample0020-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-searchDefault-all','DemoSys-IBIZSample0020-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0020-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0020s/fetchdefault")
    public ResponseEntity<List<IBIZSample0020DTO>> fetchDefault
            (IBIZSample0020SearchContext dto) {
        Page<IBIZSample0020> domains = ibizSample0020Service.searchDefault(dto) ;
        List<IBIZSample0020DTO> list = ibizSample0020DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0020-Create-all')")
    @ApiOperation(value = "批量新建员工", tags = {"员工" },  notes = "批量新建员工")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0020s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0020DTO> dtos) {
        ibizSample0020Service.createBatch(ibizSample0020DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0020-Update-all')")
    @ApiOperation(value = "批量更新员工", tags = {"员工" },  notes = "批量更新员工")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0020s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0020DTO> dtos) {
        ibizSample0020Service.updateBatch(ibizSample0020DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0020-Save-all')")
    @ApiOperation(value = "批量保存员工", tags = {"员工" },  notes = "批量保存员工")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0020s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0020DTO> dtos) {
        ibizSample0020Service.saveBatch(ibizSample0020DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0020-Save-all')")
    @ApiOperation(value = "批量导入员工", tags = {"员工" },  notes = "批量导入员工")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0020s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0020DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0020> list=ibizSample0020DtoMapping.toDomain(dtos);
            List<IBIZSample0020> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0020Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0020-Remove-all')")
    @ApiOperation(value = "批量删除员工", tags = {"员工" },  notes = "批量删除员工")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0020s","/ibizsample0020s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0020Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
