package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0015;
import cn.ibizlab.core.sample.service.IBIZSample0015Service;
import cn.ibizlab.core.sample.filter.IBIZSample0015SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"项目" })
@RestController("demoapi-ibizsample0015")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0015Resource {

    @Autowired
    public IBIZSample0015Service ibizSample0015Service;

    @Autowired
    @Lazy
    public IBIZSample0015DTOMapping ibizSample0015DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"项目" },  notes = "IBIZSample0015-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-Create-all') or hasPermission(this.ibizSample0015DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0015-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0015s")
    public ResponseEntity<IBIZSample0015DTO> create
            (@Validated @RequestBody IBIZSample0015DTO dto) {
        IBIZSample0015 domain = ibizSample0015DtoMapping.toDomain(dto);
        ibizSample0015Service.create(domain);
        IBIZSample0015 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0015DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"项目" },  notes = "IBIZSample0015-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-Get-all') or hasPermission(this.ibizSample0015DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0015-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0015s/{ibizSample0015Id}")
    public ResponseEntity<IBIZSample0015DTO> getByIbizSample0015Id
            (@PathVariable("ibizSample0015Id") String ibizSample0015Id) {
        IBIZSample0015 rt = ibizSample0015Service.get(ibizSample0015Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0015DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"项目" },  notes = "IBIZSample0015-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-Remove-all') or hasPermission(this.ibizSample0015Service.get(#ibizSample0015Id),'DemoSys-IBIZSample0015-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0015s/{ibizSample0015Id}")
    public ResponseEntity<Boolean> removeByIbizSample0015Id
            (@PathVariable("ibizSample0015Id") String ibizSample0015Id) {
        Boolean rt = ibizSample0015Service.remove(ibizSample0015Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"项目" },  notes = "IBIZSample0015-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-Update-all') or hasPermission(this.ibizSample0015Service.get(#ibizSample0015Id),'DemoSys-IBIZSample0015-Update')")
    @VersionCheck(entity = "ibizsample0015" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0015s/{ibizSample0015Id}")
    public ResponseEntity<IBIZSample0015DTO> updateByIbizSample0015Id
            (@PathVariable("ibizSample0015Id") String ibizSample0015Id, @Validated @RequestBody IBIZSample0015DTO dto) {
        IBIZSample0015 domain = ibizSample0015DtoMapping.toDomain(dto);
        domain.setIbizSample0015Id(ibizSample0015Id);
        ibizSample0015Service.update(domain);
        IBIZSample0015 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0015DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"项目" },  notes = "IBIZSample0015-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0015s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0015DTO dto) {
        IBIZSample0015 domain = ibizSample0015DtoMapping.toDomain(dto);
        Integer rt = ibizSample0015Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"项目" },  notes = "IBIZSample0015-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0015s/getdraft")
    public ResponseEntity<IBIZSample0015DTO> getDraft
            (IBIZSample0015DTO dto) {
        IBIZSample0015 domain = ibizSample0015DtoMapping.toDomain(dto);
        IBIZSample0015 rt = ibizSample0015Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0015DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"项目" },  notes = "IBIZSample0015-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-Save-all') or hasPermission(this.ibizSample0015DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0015-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0015s/save")
    public ResponseEntity<IBIZSample0015DTO> save
            (@Validated @RequestBody IBIZSample0015DTO dto) {
        IBIZSample0015 domain = ibizSample0015DtoMapping.toDomain(dto);
        ibizSample0015Service.save(domain);
        IBIZSample0015 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0015DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"项目" },  notes = "IBIZSample0015-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-searchDefault-all','DemoSys-IBIZSample0015-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0015-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0015s/fetchdefault")
    public ResponseEntity<List<IBIZSample0015DTO>> fetchDefault
            (IBIZSample0015SearchContext dto) {
        Page<IBIZSample0015> domains = ibizSample0015Service.searchDefault(dto) ;
        List<IBIZSample0015DTO> list = ibizSample0015DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0015-Create-all')")
    @ApiOperation(value = "批量新建项目", tags = {"项目" },  notes = "批量新建项目")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0015s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0015DTO> dtos) {
        ibizSample0015Service.createBatch(ibizSample0015DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0015-Update-all')")
    @ApiOperation(value = "批量更新项目", tags = {"项目" },  notes = "批量更新项目")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0015s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0015DTO> dtos) {
        ibizSample0015Service.updateBatch(ibizSample0015DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0015-Save-all')")
    @ApiOperation(value = "批量保存项目", tags = {"项目" },  notes = "批量保存项目")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0015s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0015DTO> dtos) {
        ibizSample0015Service.saveBatch(ibizSample0015DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0015-Save-all')")
    @ApiOperation(value = "批量导入项目", tags = {"项目" },  notes = "批量导入项目")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0015s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0015DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0015> list=ibizSample0015DtoMapping.toDomain(dtos);
            List<IBIZSample0015> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0015Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0015-Remove-all')")
    @ApiOperation(value = "批量删除项目", tags = {"项目" },  notes = "批量删除项目")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0015s","/ibizsample0015s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0015Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
