package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZOrderDetail;
import cn.ibizlab.core.sample.service.IBIZOrderDetailService;
import cn.ibizlab.core.sample.filter.IBIZOrderDetailSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单明细" })
@RestController("demoapi-ibizorderdetail")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZOrderDetailResource {

    @Autowired
    public IBIZOrderDetailService ibizOrderDetailService;

    @Autowired
    @Lazy
    public IBIZOrderDetailDTOMapping ibizOrderDetailDtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单明细" },  notes = "IBIZOrderDetail-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Create-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderDetail-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorderdetails")
    public ResponseEntity<IBIZOrderDetailDTO> create
            (@Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        ibizOrderDetailService.create(domain);
        IBIZOrderDetail rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单明细" },  notes = "IBIZOrderDetail-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(returnObject.body),'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorderdetails/{ibizOrderDetailId}")
    public ResponseEntity<IBIZOrderDetailDTO> getByIbizOrderDetailId
            (@PathVariable("ibizOrderDetailId") String ibizOrderDetailId) {
        IBIZOrderDetail rt = ibizOrderDetailService.get(ibizOrderDetailId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单明细" },  notes = "IBIZOrderDetail-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Remove-all') or hasPermission(this.ibizOrderDetailService.get(#ibizOrderDetailId),'DemoSys-IBIZOrderDetail-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizorderdetails/{ibizOrderDetailId}")
    public ResponseEntity<Boolean> removeByIbizOrderDetailId
            (@PathVariable("ibizOrderDetailId") String ibizOrderDetailId) {
        Boolean rt = ibizOrderDetailService.remove(ibizOrderDetailId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单明细" },  notes = "IBIZOrderDetail-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Update-all') or hasPermission(this.ibizOrderDetailService.get(#ibizOrderDetailId),'DemoSys-IBIZOrderDetail-Update')")
    @VersionCheck(entity = "ibizorderdetail" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizorderdetails/{ibizOrderDetailId}")
    public ResponseEntity<IBIZOrderDetailDTO> updateByIbizOrderDetailId
            (@PathVariable("ibizOrderDetailId") String ibizOrderDetailId, @Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderDetailId(ibizOrderDetailId);
        ibizOrderDetailService.update(domain);
        IBIZOrderDetail rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单明细" },  notes = "IBIZOrderDetail-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorderdetails/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        Integer rt = ibizOrderDetailService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "CountMoney", tags = {"订单明细" },  notes = "IBIZOrderDetail-CountMoney")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-CountMoney-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderDetail-CountMoney')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorderdetails/{ibizOrderDetailId}/countmoney")
    public ResponseEntity<IBIZOrderDetailDTO> countMoneyByIbizOrderDetailId
            (@PathVariable("ibizOrderDetailId") String ibizOrderDetailId, @Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderDetailId(ibizOrderDetailId);
        IBIZOrderDetail rt = ibizOrderDetailService.countMoney(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单明细" },  notes = "IBIZOrderDetail-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorderdetails/getdraft")
    public ResponseEntity<IBIZOrderDetailDTO> getDraft
            (IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        IBIZOrderDetail rt = ibizOrderDetailService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "GetUnitAndPrice", tags = {"订单明细" },  notes = "IBIZOrderDetail-GetUnitAndPrice")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetUnitAndPrice-all') or hasPermission(this.ibizOrderDetailService.get(#ibizOrderDetailId),'DemoSys-IBIZOrderDetail-GetUnitAndPrice')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorderdetails/{ibizOrderDetailId}/getunitandprice")
    public ResponseEntity<IBIZOrderDetailDTO> getUnitAndPriceByIbizOrderDetailId
            (@PathVariable("ibizOrderDetailId") String ibizOrderDetailId) {
        IBIZOrderDetail rt = ibizOrderDetailService.getUnitAndPrice(ibizOrderDetailId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单明细" },  notes = "IBIZOrderDetail-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Save-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderDetail-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorderdetails/save")
    public ResponseEntity<IBIZOrderDetailDTO> save
            (@Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        ibizOrderDetailService.save(domain);
        IBIZOrderDetail rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchCSMXDY", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchCSMXDY")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorderdetails/fetchcsmxdy")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchCsmxdy
            (IBIZOrderDetailSearchContext dto) {
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchCsmxdy(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorderdetails/fetchdefault")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchDefault
            (IBIZOrderDetailSearchContext dto) {
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchDefault(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchLOGIC_0007", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchLOGIC_0007")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorderdetails/fetchlogic_0007")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchLogic0007
            (IBIZOrderDetailSearchContext dto) {
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchLogic0007(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchX", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchX")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorderdetails/fetchx")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchX
            (IBIZOrderDetailSearchContext dto) {
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchX(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "创建Create", tags = {"订单明细" },  notes = "IBIZOrderDetail-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Create-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderDetail-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders/{ibizOrderId}/ibizorderdetails")
    public ResponseEntity<IBIZOrderDetailDTO> createByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, @Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderId(ibizOrderId);
        ibizOrderDetailService.create(domain);
        IBIZOrderDetail rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单明细" },  notes = "IBIZOrderDetail-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(returnObject.body),'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}/ibizorderdetails/{ibizOrderDetailId}")
    public ResponseEntity<IBIZOrderDetailDTO> getByIbizOrderIdAndIbizOrderDetailId
            (@PathVariable("ibizOrderId") String ibizOrderId, @PathVariable("ibizOrderDetailId") String ibizOrderDetailId) {
        IBIZOrderDetail rt = ibizOrderDetailService.get(ibizOrderDetailId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单明细" },  notes = "IBIZOrderDetail-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Remove-all') or hasPermission(this.ibizOrderDetailService.get(#ibizOrderDetailId),'DemoSys-IBIZOrderDetail-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizorders/{ibizOrderId}/ibizorderdetails/{ibizOrderDetailId}")
    public ResponseEntity<Boolean> removeByIbizOrderIdAndIbizOrderDetailId
            (@PathVariable("ibizOrderId") String ibizOrderId, @PathVariable("ibizOrderDetailId") String ibizOrderDetailId) {
        Boolean rt = ibizOrderDetailService.remove(ibizOrderDetailId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单明细" },  notes = "IBIZOrderDetail-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Update-all') or hasPermission(this.ibizOrderDetailService.get(#ibizOrderDetailId),'DemoSys-IBIZOrderDetail-Update')")
    @VersionCheck(entity = "ibizorderdetail" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizorders/{ibizOrderId}/ibizorderdetails/{ibizOrderDetailId}")
    public ResponseEntity<IBIZOrderDetailDTO> updateByIbizOrderIdAndIbizOrderDetailId
            (@PathVariable("ibizOrderId") String ibizOrderId, @PathVariable("ibizOrderDetailId") String ibizOrderDetailId, @Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderDetailId(ibizOrderDetailId);
        ibizOrderDetailService.update(domain);
        IBIZOrderDetail rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单明细" },  notes = "IBIZOrderDetail-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders/{ibizOrderId}/ibizorderdetails/checkkey")
    public ResponseEntity<Integer> checkKeyByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, @Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderId(ibizOrderId);
        Integer rt = ibizOrderDetailService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "CountMoney", tags = {"订单明细" },  notes = "IBIZOrderDetail-CountMoney")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-CountMoney-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderDetail-CountMoney')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders/{ibizOrderId}/ibizorderdetails/{ibizOrderDetailId}/countmoney")
    public ResponseEntity<IBIZOrderDetailDTO> countMoneyByIbizOrderIdAndIbizOrderDetailId
            (@PathVariable("ibizOrderId") String ibizOrderId, @PathVariable("ibizOrderDetailId") String ibizOrderDetailId, @Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderDetailId(ibizOrderDetailId);
        IBIZOrderDetail rt = ibizOrderDetailService.countMoney(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单明细" },  notes = "IBIZOrderDetail-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}/ibizorderdetails/getdraft")
    public ResponseEntity<IBIZOrderDetailDTO> getDraftByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderId(ibizOrderId);
        IBIZOrderDetail rt = ibizOrderDetailService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "GetUnitAndPrice", tags = {"订单明细" },  notes = "IBIZOrderDetail-GetUnitAndPrice")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetUnitAndPrice-all') or hasPermission(this.ibizOrderDetailService.get(#ibizOrderDetailId),'DemoSys-IBIZOrderDetail-GetUnitAndPrice')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}/ibizorderdetails/{ibizOrderDetailId}/getunitandprice")
    public ResponseEntity<IBIZOrderDetailDTO> getUnitAndPriceByIbizOrderIdAndIbizOrderDetailId
            (@PathVariable("ibizOrderId") String ibizOrderId, @PathVariable("ibizOrderDetailId") String ibizOrderDetailId) {
        IBIZOrderDetail rt = ibizOrderDetailService.getUnitAndPrice(ibizOrderDetailId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单明细" },  notes = "IBIZOrderDetail-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-Save-all') or hasPermission(this.ibizOrderDetailDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderDetail-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders/{ibizOrderId}/ibizorderdetails/save")
    public ResponseEntity<IBIZOrderDetailDTO> saveByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, @Validated @RequestBody IBIZOrderDetailDTO dto) {
        IBIZOrderDetail domain = ibizOrderDetailDtoMapping.toDomain(dto);
        domain.setIbizOrderId(ibizOrderId);
        ibizOrderDetailService.save(domain);
        IBIZOrderDetail rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDetailDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchCSMXDY", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchCSMXDY")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}/ibizorderdetails/fetchcsmxdy")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchCsmxdyByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, IBIZOrderDetailSearchContext dto) {
        dto.setIbizOrderIdEQ(ibizOrderId);
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchCsmxdy(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}/ibizorderdetails/fetchdefault")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchDefaultByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, IBIZOrderDetailSearchContext dto) {
        dto.setIbizOrderIdEQ(ibizOrderId);
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchDefault(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchLOGIC_0007", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchLOGIC_0007")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}/ibizorderdetails/fetchlogic_0007")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchLogic0007ByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, IBIZOrderDetailSearchContext dto) {
        dto.setIbizOrderIdEQ(ibizOrderId);
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchLogic0007(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchX", tags = {"订单明细" },  notes = "IBIZOrderDetail-FetchX")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all','DemoSys-IBIZOrderDetail-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderDetail-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}/ibizorderdetails/fetchx")
    public ResponseEntity<List<IBIZOrderDetailDTO>> fetchXByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, IBIZOrderDetailSearchContext dto) {
        dto.setIbizOrderIdEQ(ibizOrderId);
        Page<IBIZOrderDetail> domains = ibizOrderDetailService.searchX(dto) ;
        List<IBIZOrderDetailDTO> list = ibizOrderDetailDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderDetail-Create-all')")
    @ApiOperation(value = "批量新建订单明细", tags = {"订单明细" },  notes = "批量新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizorderdetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZOrderDetailDTO> dtos) {
        ibizOrderDetailService.createBatch(ibizOrderDetailDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderDetail-Update-all')")
    @ApiOperation(value = "批量更新订单明细", tags = {"订单明细" },  notes = "批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizorderdetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZOrderDetailDTO> dtos) {
        ibizOrderDetailService.updateBatch(ibizOrderDetailDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderDetail-Save-all')")
    @ApiOperation(value = "批量保存订单明细", tags = {"订单明细" },  notes = "批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizorderdetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZOrderDetailDTO> dtos) {
        ibizOrderDetailService.saveBatch(ibizOrderDetailDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderDetail-Save-all')")
    @ApiOperation(value = "批量导入订单明细", tags = {"订单明细" },  notes = "批量导入订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizorderdetails/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZOrderDetailDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZOrderDetail> list=ibizOrderDetailDtoMapping.toDomain(dtos);
            List<IBIZOrderDetail> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizOrderDetailService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderDetail-Remove-all')")
    @ApiOperation(value = "批量删除订单明细", tags = {"订单明细" },  notes = "批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizorderdetails","/ibizorderdetails/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizOrderDetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
