package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0020DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("员工")
public class IBIZSample0020DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 部门id
     */
    @JsonProperty("ibizsample0019id")
    @JSONField(name = "ibizsample0019id")
    @ApiModelProperty("部门id")
    private String ibizsample0019Id;

    /**
     * 部门名称
     */
    @JsonProperty("ibizsample0019name")
    @JSONField(name = "ibizsample0019name")
    @ApiModelProperty("部门名称")
    private String ibizsample0019Name;

    /**
     * 员工标识
     */
    @JsonProperty("ibizsample0020id")
    @JSONField(name = "ibizsample0020id")
    @ApiModelProperty("员工标识")
    private String ibizsample0020Id;

    /**
     * 员工名称
     */
    @JsonProperty("ibizsample0020name")
    @JSONField(name = "ibizsample0020name")
    @ApiModelProperty("员工名称")
    private String ibizsample0020Name;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [部门id]
     */
    public void setIbizsample0019Id(String ibizsample0019Id) {
        this.ibizsample0019Id = ibizsample0019Id;
        this.modify("ibizsample0019id", ibizsample0019Id);
    }

    /**
     * 设置 [部门名称]
     */
    public void setIbizsample0019Name(String ibizsample0019Name) {
        this.ibizsample0019Name = ibizsample0019Name;
        this.modify("ibizsample0019name", ibizsample0019Name);
    }

    /**
     * 设置 [员工名称]
     */
    public void setIbizsample0020Name(String ibizsample0020Name) {
        this.ibizsample0020Name = ibizsample0020Name;
        this.modify("ibizsample0020name", ibizsample0020Name);
    }


}
