package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.MicroComponent;
import cn.ibizlab.core.sample.filter.MicroComponentSearchContext;
import cn.ibizlab.core.sample.service.MicroComponentService;
import cn.ibizlab.core.sample.mapper.MicroComponentMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[微组件] 服务对象接口实现
 */
@Slf4j
@Service("MicroComponentService")
public class MicroComponentServiceBase extends ServiceImpl<MicroComponentMapper,MicroComponent> implements MicroComponentService {


    protected int batchSize = 500;

    public MicroComponent get(MicroComponent et) {
        MicroComponent rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,微组件:"+et.getMicroComponentId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<MicroComponent> getByEntities(List<MicroComponent> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public MicroComponent getDraft(MicroComponent et) {
        return et;
    }

    public Integer checkKey(MicroComponent et) {
        return ( (!ObjectUtils.isEmpty(et.getMicroComponentId())) && this.count(Wrappers.<MicroComponent>query().eq("microcomponentid", et.getMicroComponentId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(MicroComponent et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<MicroComponent> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(MicroComponent et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("microcomponentid", et.getMicroComponentId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<MicroComponent> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(MicroComponent et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<MicroComponent> list) {
        List<MicroComponent> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getMicroComponentId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<MicroComponent> _create=new ArrayList<>();
        List<MicroComponent> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getMicroComponentId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(MicroComponent et) {
        String key = et.getMicroComponentId();

        if(!remove(new QueryWrapper<MicroComponent>()
                .eq("microcomponentid", et.getMicroComponentId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<MicroComponent> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<MicroComponent> searchDefault(MicroComponentSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<MicroComponent> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<MicroComponent>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<MicroComponent> listDefault(MicroComponentSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}