package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZAPPEDITOR;
import cn.ibizlab.core.sample.filter.IBIZAPPEDITORSearchContext;

public interface IBIZAPPEDITORService extends IService<IBIZAPPEDITOR> {

    default IBIZAPPEDITORService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZAPPEDITOR get(IBIZAPPEDITOR et);
    default IBIZAPPEDITOR get(String key) {
        IBIZAPPEDITOR et = new IBIZAPPEDITOR();
        et.setIbizappeditorid(key);
        return getSelf().get(et);
    }
    default List<IBIZAPPEDITOR> getByIds(Collection<String> ids) {
        List<IBIZAPPEDITOR> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPEDITOR et = new IBIZAPPEDITOR();
            et.setIbizappeditorid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZAPPEDITOR> getByEntities(List<IBIZAPPEDITOR> entities);

    IBIZAPPEDITOR getDraft(IBIZAPPEDITOR et);

    Integer checkKey(IBIZAPPEDITOR et);

    boolean create(IBIZAPPEDITOR et);
    boolean createBatch(List<IBIZAPPEDITOR> list);

    boolean update(IBIZAPPEDITOR et);
    boolean updateBatch(List<IBIZAPPEDITOR> list);

    boolean save(IBIZAPPEDITOR et);
    boolean saveBatch(List<IBIZAPPEDITOR> list);

    default boolean remove(String key) {
        IBIZAPPEDITOR et = new IBIZAPPEDITOR();
        et.setIbizappeditorid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZAPPEDITOR et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZAPPEDITOR> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPEDITOR et = new IBIZAPPEDITOR();
            et.setIbizappeditorid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZAPPEDITOR> entities);

    Page<IBIZAPPEDITOR> searchDefault(IBIZAPPEDITORSearchContext context);
    List<IBIZAPPEDITOR> listDefault(IBIZAPPEDITORSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}