package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZTASKTEAM;
/**
 * 关系型数据实体[IBIZTASKTEAM] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("任务团队")
public class IBIZTASKTEAMSearchContext extends QueryWrapperContext<IBIZTASKTEAM> {

    @JsonProperty("n_ibiztaskteamname_like")
    @JSONField(name = "n_ibiztaskteamname_like")
    @ApiModelProperty("任务团队名称LIKE")
	private String ibiztaskteamNameLIKE;
	public IBIZTASKTEAMSearchContext setIbiztaskteamNameLIKE(String ibiztaskteamNameLIKE) {
        this.ibiztaskteamNameLIKE = ibiztaskteamNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibiztaskteamNameLIKE)){
            this.getSearchCond().like("ibiztaskteamname", ibiztaskteamNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibiztaskteamid_eq")
    @JSONField(name = "n_ibiztaskteamid_eq")
    @ApiModelProperty("任务团队标识EQ")
	private String ibiztaskteamidEQ;
	public IBIZTASKTEAMSearchContext setIbiztaskteamidEQ(String ibiztaskteamidEQ) {
        this.ibiztaskteamidEQ = ibiztaskteamidEQ;
        if(!ObjectUtils.isEmpty(this.ibiztaskteamidEQ)){
            this.getSearchCond().eq("ibiztaskteamid", ibiztaskteamidEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_root_eq")
    @JSONField(name = "n_root_eq")
    @ApiModelProperty("任务标识EQ")
	private String rootEQ;
	public IBIZTASKTEAMSearchContext setRootEQ(String rootEQ) {
        this.rootEQ = rootEQ;
        if(!ObjectUtils.isEmpty(this.rootEQ)){
            this.getSearchCond().eq("root", rootEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibiztaskteamname", query)
            );
		}
	}
}