package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample;
/**
 * 关系型数据实体[IBIZSample] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例数据库")
public class IBIZSampleSearchContext extends QueryWrapperContext<IBIZSample> {

    @JsonProperty("n_ibizsamplename_like")
    @JSONField(name = "n_ibizsamplename_like")
    @ApiModelProperty("示例数据库名称LIKE")
	private String ibizSampleNameLIKE;
	public IBIZSampleSearchContext setIbizSampleNameLIKE(String ibizSampleNameLIKE) {
        this.ibizSampleNameLIKE = ibizSampleNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSampleNameLIKE)){
            this.getSearchCond().like("ibizsamplename", ibizSampleNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsampleid_like")
    @JSONField(name = "n_ibizsampleid_like")
    @ApiModelProperty("示例数据库标识LIKE")
	private String ibizSampleIdLIKE;
	public IBIZSampleSearchContext setIbizSampleIdLIKE(String ibizSampleIdLIKE) {
        this.ibizSampleIdLIKE = ibizSampleIdLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSampleIdLIKE)){
            this.getSearchCond().like("ibizsampleid", ibizSampleIdLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsampleid_eq")
    @JSONField(name = "n_ibizsampleid_eq")
    @ApiModelProperty("示例数据库标识EQ")
	private String ibizSampleIdEQ;
	public IBIZSampleSearchContext setIbizSampleIdEQ(String ibizSampleIdEQ) {
        this.ibizSampleIdEQ = ibizSampleIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSampleIdEQ)){
            this.getSearchCond().eq("ibizsampleid", ibizSampleIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_sampletype_eq")
    @JSONField(name = "n_sampletype_eq")
    @ApiModelProperty("示例类型EQ")
	private String sampleTypeEQ;
	public IBIZSampleSearchContext setSampleTypeEQ(String sampleTypeEQ) {
        this.sampleTypeEQ = sampleTypeEQ;
        if(!ObjectUtils.isEmpty(this.sampleTypeEQ)){
            this.getSearchCond().eq("sampletype", sampleTypeEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsamplename", query)
            );
		}
	}
}