package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZAPPVIEW;
/**
 * 关系型数据实体[IBIZAPPVIEW] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("应用视图")
public class IBIZAPPVIEWSearchContext extends QueryWrapperContext<IBIZAPPVIEW> {

    @JsonProperty("n_ibizappviewname_like")
    @JSONField(name = "n_ibizappviewname_like")
    @ApiModelProperty("应用视图名称LIKE")
	private String ibizappviewNameLIKE;
	public IBIZAPPVIEWSearchContext setIbizappviewNameLIKE(String ibizappviewNameLIKE) {
        this.ibizappviewNameLIKE = ibizappviewNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizappviewNameLIKE)){
            this.getSearchCond().like("ibizappviewname", ibizappviewNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizappviewid_eq")
    @JSONField(name = "n_ibizappviewid_eq")
    @ApiModelProperty("应用视图标识EQ")
	private String ibizappviewidEQ;
	public IBIZAPPVIEWSearchContext setIbizappviewidEQ(String ibizappviewidEQ) {
        this.ibizappviewidEQ = ibizappviewidEQ;
        if(!ObjectUtils.isEmpty(this.ibizappviewidEQ)){
            this.getSearchCond().eq("ibizappviewid", ibizappviewidEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizappviewname", query)
            );
		}
	}
}