package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZSample0003;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0014", resultMap = "IBIZSample0014ResultMap")
@ApiModel(value = "IBIZSAMPLE0014", description = "员工")
public class IBIZSample0014 extends EntityMP implements Serializable
{

    /**
     * 员工名称
     */
    @TableField(value = "ibizsample0014name")
    @DEField(name = "ibizsample0014name")
    @JsonProperty("ibizsample0014name")
    @JSONField(name = "ibizsample0014name")
    @ApiModelProperty(value = "ibizsample0014name", notes = "员工名称")
    private String ibizSample0014Name;

    /**
     * 员工标识
     */
    @Id
    @TableId(value = "ibizsample0014id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0014id" , isKeyField = true)
    @JsonProperty("ibizsample0014id")
    @JSONField(name = "ibizsample0014id")
    @ApiModelProperty(value = "ibizsample0014id", notes = "员工标识")
    private String ibizSample0014Id;

    /**
     * 员工编号
     */
    @TableField(value = "sn")
    @DEField(name = "sn")
    @JsonProperty("sn")
    @JSONField(name = "sn")
    @ApiModelProperty(value = "sn", notes = "员工编号")
    private String sn;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 名称
     */
    @TableField(value = "ibizsample0003name" , exist = false)
    @DEField(name = "ibizsample0003name")
    @JsonProperty("ibizsample0003name")
    @JSONField(name = "ibizsample0003name")
    @ApiModelProperty(value = "ibizsample0003name", notes = "名称")
    private String ibizsample0003Name;

    /**
     * IBIZSAMPLE0003标识
     */
    @TableField(value = "ibizsample0003id")
    @DEField(name = "ibizsample0003id")
    @JsonProperty("ibizsample0003id")
    @JSONField(name = "ibizsample0003id")
    @ApiModelProperty(value = "ibizsample0003id", notes = "IBIZSAMPLE0003标识")
    private String ibizsample0003Id;


    /**
     * 示例实体03
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizsample0003", notes = "")
    private IBIZSample0003 ibizSample0003;


    /**
     * 设置 [员工名称]
     */
    public void setIbizSample0014Name(String ibizSample0014Name) {
        this.ibizSample0014Name = ibizSample0014Name;
        this.modify("ibizsample0014name", ibizSample0014Name);
    }


    /**
     * 设置 [员工编号]
     */
    public void setSn(String sn) {
        this.sn = sn;
        this.modify("sn", sn);
    }





    /**
     * 设置 [名称]
     */
    public void setIbizsample0003Name(String ibizsample0003Name) {
        this.ibizsample0003Name = ibizsample0003Name;
        this.modify("ibizsample0003name", ibizsample0003Name);
    }

    /**
     * 设置 [IBIZSAMPLE0003标识]
     */
    public void setIbizsample0003Id(String ibizsample0003Id) {
        this.ibizsample0003Id = ibizsample0003Id;
        this.modify("ibizsample0003id", ibizsample0003Id);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0014id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}