package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0011", resultMap = "IBIZSample0011ResultMap")
@ApiModel(value = "IBIZSAMPLE0011", description = "订单明细")
public class IBIZSample0011 extends EntityMP implements Serializable
{

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 数量
     */
    @TableField(value = "quantity")
    @DEField(name = "quantity")
    @JsonProperty("quantity")
    @JSONField(name = "quantity")
    @ApiModelProperty(value = "quantity", notes = "数量")
    private Integer quantity;

    /**
     * 订单明细标识
     */
    @Id
    @TableId(value = "ibizsample0011id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0011id" , isKeyField = true)
    @JsonProperty("ibizsample0011id")
    @JSONField(name = "ibizsample0011id")
    @ApiModelProperty(value = "ibizsample0011id", notes = "订单明细标识")
    private String ibizSample0011Id;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 订单明细名称
     */
    @TableField(value = "ibizsample0011name")
    @DEField(name = "ibizsample0011name")
    @JsonProperty("ibizsample0011name")
    @JSONField(name = "ibizsample0011name")
    @ApiModelProperty(value = "ibizsample0011name", notes = "订单明细名称")
    private String ibizSample0011Name;

    /**
     * 小计
     */
    @TableField(value = "amount" , exist = false)
    @DEField(name = "amount")
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty(value = "amount", notes = "小计")
    private BigDecimal amount;

    /**
     * 订单名称
     */
    @TableField(value = "ibizsample0010name" , exist = false)
    @DEField(name = "ibizsample0010name")
    @JsonProperty("ibizsample0010name")
    @JSONField(name = "ibizsample0010name")
    @ApiModelProperty(value = "ibizsample0010name", notes = "订单名称")
    private String ibizSample0010Name;

    /**
     * 统一产品名称
     */
    @TableField(value = "ibizuniproductname" , exist = false)
    @DEField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    @JSONField(name = "ibizuniproductname")
    @ApiModelProperty(value = "ibizuniproductname", notes = "统一产品名称")
    private String ibizuniProductName;

    /**
     * 单价
     */
    @TableField(value = "unitprice" , exist = false)
    @DEField(name = "unitprice")
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty(value = "unitprice", notes = "单价")
    private BigDecimal unitPrice;

    /**
     * 单位
     */
    @TableField(value = "unit" , exist = false)
    @DEField(name = "unit")
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty(value = "unit", notes = "单位")
    private String unit;

    /**
     * 订单标识
     */
    @TableField(value = "ibizsample0010id")
    @DEField(name = "ibizsample0010id")
    @JsonProperty("ibizsample0010id")
    @JSONField(name = "ibizsample0010id")
    @ApiModelProperty(value = "ibizsample0010id", notes = "订单标识")
    private String ibizSample0010Id;

    /**
     * 统一产品标识
     */
    @TableField(value = "ibizuniproductid")
    @DEField(name = "ibizuniproductid")
    @JsonProperty("ibizuniproductid")
    @JSONField(name = "ibizuniproductid")
    @ApiModelProperty(value = "ibizuniproductid", notes = "统一产品标识")
    private String ibizuniProductId;


    /**
     * 订单
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizsample0010", notes = "")
    private IBIZSample0010 ibizsample0010;
    /**
     * 统一产品（索引主实体）
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizuniproduct", notes = "")
    private IBIZUNIProduct ibizuniproduct;



    /**
     * 设置 [数量]
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
        this.modify("quantity", quantity);
    }





    /**
     * 设置 [订单明细名称]
     */
    public void setIbizSample0011Name(String ibizSample0011Name) {
        this.ibizSample0011Name = ibizSample0011Name;
        this.modify("ibizsample0011name", ibizSample0011Name);
    }

    /**
     * 设置 [小计]
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [订单名称]
     */
    public void setIbizSample0010Name(String ibizSample0010Name) {
        this.ibizSample0010Name = ibizSample0010Name;
        this.modify("ibizsample0010name", ibizSample0010Name);
    }

    /**
     * 设置 [统一产品名称]
     */
    public void setIbizuniProductName(String ibizuniProductName) {
        this.ibizuniProductName = ibizuniProductName;
        this.modify("ibizuniproductname", ibizuniProductName);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }

    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [订单标识]
     */
    public void setIbizSample0010Id(String ibizSample0010Id) {
        this.ibizSample0010Id = ibizSample0010Id;
        this.modify("ibizsample0010id", ibizSample0010Id);
    }

    /**
     * 设置 [统一产品标识]
     */
    public void setIbizuniProductId(String ibizuniProductId) {
        this.ibizuniProductId = ibizuniProductId;
        this.modify("ibizuniproductid", ibizuniProductId);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0011id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}