package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0003;
import cn.ibizlab.core.sample.service.IBIZSample0003Service;
import cn.ibizlab.core.sample.filter.IBIZSample0003SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体03" })
@RestController("demoapi-ibizsample0003")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0003Resource {

    @Autowired
    public IBIZSample0003Service ibizSample0003Service;

    @Autowired
    @Lazy
    public IBIZSample0003DTOMapping ibizSample0003DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"示例实体03" },  notes = "IBIZSample0003-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-Create-all') or hasPermission(this.ibizSample0003DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0003-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0003s")
    public ResponseEntity<IBIZSample0003DTO> create
            (@Validated @RequestBody IBIZSample0003DTO dto) {
        IBIZSample0003 domain = ibizSample0003DtoMapping.toDomain(dto);
        ibizSample0003Service.create(domain);
        IBIZSample0003 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0003DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"示例实体03" },  notes = "IBIZSample0003-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-Get-all') or hasPermission(this.ibizSample0003DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0003-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0003s/{ibizsample0003Id}")
    public ResponseEntity<IBIZSample0003DTO> getByIbizsample0003Id
            (@PathVariable("ibizsample0003Id") String ibizsample0003Id) {
        IBIZSample0003 rt = ibizSample0003Service.get(ibizsample0003Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0003DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"示例实体03" },  notes = "IBIZSample0003-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-Remove-all') or hasPermission(this.ibizSample0003Service.get(#ibizsample0003Id),'DemoSys-IBIZSample0003-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0003s/{ibizsample0003Id}")
    public ResponseEntity<Boolean> removeByIbizsample0003Id
            (@PathVariable("ibizsample0003Id") String ibizsample0003Id) {
        Boolean rt = ibizSample0003Service.remove(ibizsample0003Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"示例实体03" },  notes = "IBIZSample0003-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-Update-all') or hasPermission(this.ibizSample0003Service.get(#ibizsample0003Id),'DemoSys-IBIZSample0003-Update')")
    @VersionCheck(entity = "ibizsample0003" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0003s/{ibizsample0003Id}")
    public ResponseEntity<IBIZSample0003DTO> updateByIbizsample0003Id
            (@PathVariable("ibizsample0003Id") String ibizsample0003Id, @Validated @RequestBody IBIZSample0003DTO dto) {
        IBIZSample0003 domain = ibizSample0003DtoMapping.toDomain(dto);
        domain.setIbizsample0003Id(ibizsample0003Id);
        ibizSample0003Service.update(domain);
        IBIZSample0003 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0003DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"示例实体03" },  notes = "IBIZSample0003-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0003s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0003DTO dto) {
        IBIZSample0003 domain = ibizSample0003DtoMapping.toDomain(dto);
        Integer rt = ibizSample0003Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"示例实体03" },  notes = "IBIZSample0003-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0003s/getdraft")
    public ResponseEntity<IBIZSample0003DTO> getDraft
            (IBIZSample0003DTO dto) {
        IBIZSample0003 domain = ibizSample0003DtoMapping.toDomain(dto);
        IBIZSample0003 rt = ibizSample0003Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0003DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"示例实体03" },  notes = "IBIZSample0003-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-Save-all') or hasPermission(this.ibizSample0003DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0003-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0003s/save")
    public ResponseEntity<IBIZSample0003DTO> save
            (@Validated @RequestBody IBIZSample0003DTO dto) {
        IBIZSample0003 domain = ibizSample0003DtoMapping.toDomain(dto);
        ibizSample0003Service.save(domain);
        IBIZSample0003 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0003DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchCurData", tags = {"示例实体03" },  notes = "IBIZSample0003-FetchCurData")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchCurData-all','DemoSys-IBIZSample0003-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0003-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0003s/fetchcurdata")
    public ResponseEntity<List<IBIZSample0003DTO>> fetchCurData
            (IBIZSample0003SearchContext dto) {
        Page<IBIZSample0003> domains = ibizSample0003Service.searchCurData(dto) ;
        List<IBIZSample0003DTO> list = ibizSample0003DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"示例实体03" },  notes = "IBIZSample0003-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchDefault-all','DemoSys-IBIZSample0003-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0003-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0003s/fetchdefault")
    public ResponseEntity<List<IBIZSample0003DTO>> fetchDefault
            (IBIZSample0003SearchContext dto) {
        Page<IBIZSample0003> domains = ibizSample0003Service.searchDefault(dto) ;
        List<IBIZSample0003DTO> list = ibizSample0003DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchTopData", tags = {"示例实体03" },  notes = "IBIZSample0003-FetchTopData")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchTopData-all','DemoSys-IBIZSample0003-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0003-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0003s/fetchtopdata")
    public ResponseEntity<List<IBIZSample0003DTO>> fetchTopData
            (IBIZSample0003SearchContext dto) {
        Page<IBIZSample0003> domains = ibizSample0003Service.searchTopData(dto) ;
        List<IBIZSample0003DTO> list = ibizSample0003DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0003-Create-all')")
    @ApiOperation(value = "批量新建示例实体03", tags = {"示例实体03" },  notes = "批量新建示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0003s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0003DTO> dtos) {
        ibizSample0003Service.createBatch(ibizSample0003DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0003-Update-all')")
    @ApiOperation(value = "批量更新示例实体03", tags = {"示例实体03" },  notes = "批量更新示例实体03")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0003s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0003DTO> dtos) {
        ibizSample0003Service.updateBatch(ibizSample0003DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0003-Save-all')")
    @ApiOperation(value = "批量保存示例实体03", tags = {"示例实体03" },  notes = "批量保存示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0003s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0003DTO> dtos) {
        ibizSample0003Service.saveBatch(ibizSample0003DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0003-Save-all')")
    @ApiOperation(value = "批量导入示例实体03", tags = {"示例实体03" },  notes = "批量导入示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0003s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0003DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0003> list=ibizSample0003DtoMapping.toDomain(dtos);
            List<IBIZSample0003> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0003Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0003-Remove-all')")
    @ApiOperation(value = "批量删除示例实体03", tags = {"示例实体03" },  notes = "批量删除示例实体03")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0003s","/ibizsample0003s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0003Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
