package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0013;
import cn.ibizlab.core.sample.filter.IBIZSample0013SearchContext;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;

public interface IBIZSample0013Service extends IService<IBIZSample0013> {

    default IBIZSample0013Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0013 get(IBIZSample0013 et);
    default IBIZSample0013 get(String key) {
        IBIZSample0013 et = new IBIZSample0013();
        et.setIbizSample0013Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0013> getByIds(Collection<String> ids) {
        List<IBIZSample0013> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0013 et = new IBIZSample0013();
            et.setIbizSample0013Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0013> getByEntities(List<IBIZSample0013> entities);

    IBIZSample0013 getDraft(IBIZSample0013 et);

    Integer checkKey(IBIZSample0013 et);

    boolean create(IBIZSample0013 et);
    boolean createBatch(List<IBIZSample0013> list);

    boolean update(IBIZSample0013 et);
    boolean updateBatch(List<IBIZSample0013> list);

    boolean save(IBIZSample0013 et);
    boolean saveBatch(List<IBIZSample0013> list);

    default boolean remove(String key) {
        IBIZSample0013 et = new IBIZSample0013();
        et.setIbizSample0013Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0013 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0013> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0013 et = new IBIZSample0013();
            et.setIbizSample0013Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0013> entities);

    Page<IBIZSample0013> searchDefault(IBIZSample0013SearchContext context);
    List<IBIZSample0013> listDefault(IBIZSample0013SearchContext context);

    List<IBIZSample0013> selectByIbizSample0012Id(String ibizSample0012Id);
    boolean removeByIbizSample0012Id(String ibizSample0012Id);
    boolean resetByIbizSample0012Id(String ibizSample0012Id);
    boolean saveByIbizsample0012(cn.ibizlab.core.sample.domain.IBIZSample0012 ibizSample0012,List<IBIZSample0013> list);
    default boolean saveByIbizSample0012Id(String ibizSample0012Id,List<IBIZSample0013> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0012 et = new cn.ibizlab.core.sample.domain.IBIZSample0012();
        et.setIbizSample0012Id(ibizSample0012Id);
        return getSelf().saveByIbizsample0012(et,list);
    }

    List<IBIZSample0013> selectByIbizuniProductId(String ibizuniProductId);
    boolean removeByIbizuniProductId(String ibizuniProductId);
    boolean resetByIbizuniProductId(String ibizuniProductId);
    boolean saveByIbizuniproduct(cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizuniProduct,List<IBIZSample0013> list);
    default boolean saveByIbizuniProductId(String ibizuniProductId,List<IBIZSample0013> list) {
        cn.ibizlab.core.sample.domain.IBIZUNIProduct et = new cn.ibizlab.core.sample.domain.IBIZUNIProduct();
        et.setIbizuniProductId(ibizuniProductId);
        return getSelf().saveByIbizuniproduct(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}