package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZOrder;
import cn.ibizlab.core.sample.filter.IBIZOrderSearchContext;
import cn.ibizlab.core.sample.domain.IBIZCustomer;

public interface IBIZOrderService extends IService<IBIZOrder> {

    default IBIZOrderService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZOrder get(IBIZOrder et);
    default IBIZOrder get(String key) {
        IBIZOrder et = new IBIZOrder();
        et.setIbizOrderId(key);
        return getSelf().get(et);
    }
    default List<IBIZOrder> getByIds(Collection<String> ids) {
        List<IBIZOrder> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZOrder et = new IBIZOrder();
            et.setIbizOrderId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZOrder> getByEntities(List<IBIZOrder> entities);

    IBIZOrder getDraft(IBIZOrder et);

    Integer checkKey(IBIZOrder et);

    boolean create(IBIZOrder et);
    boolean createBatch(List<IBIZOrder> list);

    boolean update(IBIZOrder et);
    boolean updateBatch(List<IBIZOrder> list);

    boolean save(IBIZOrder et);
    boolean saveBatch(List<IBIZOrder> list);

    default boolean remove(String key) {
        IBIZOrder et = new IBIZOrder();
        et.setIbizOrderId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZOrder et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZOrder> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZOrder et = new IBIZOrder();
            et.setIbizOrderId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZOrder> entities);

    default IBIZOrder createTemp(IBIZOrder dto) {
        return dto;
    }

    default IBIZOrder createTempMajor(IBIZOrder dto) {
        return dto;
    }

    default IBIZOrder updateTemp(IBIZOrder dto) {
        return dto;
    }

    default IBIZOrder updateTempMajor(IBIZOrder dto) {
        return dto;
    }

    default List<String> removeTemp(List<String> keys) {
        return keys;
    }

    default List<String> removeTempMajor(List<String> keys) {
        return keys;
    }

    default IBIZOrder getTemp(String key) {
        return null;
    }

    default IBIZOrder getTempMajor(String key) {
        return null;
    }

    default IBIZOrder getDraftTemp(IBIZOrder dto) {
        return null;
    }

    default IBIZOrder getDraftTempMajor(IBIZOrder dto) {
        return null;
    }

    default IBIZOrder buiAction(IBIZOrder dto) {
        return dto;
    }

    default IBIZOrder mulUpdate(IBIZOrder dto) {
        return dto;
    }

    Page<IBIZOrder> searchCsdy(IBIZOrderSearchContext context);
    List<IBIZOrder> listCsdy(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchCurState30(IBIZOrderSearchContext context);
    List<IBIZOrder> listCurState30(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchDdjetjbb(IBIZOrderSearchContext context);
    List<IBIZOrder> listDdjetjbb(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchDdReport(IBIZOrderSearchContext context);
    List<IBIZOrder> listDdReport(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchDyddmxsjy(IBIZOrderSearchContext context);
    List<IBIZOrder> listDyddmxsjy(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchDefault(IBIZOrderSearchContext context);
    List<IBIZOrder> listDefault(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchEchartsDefaultDataSource(IBIZOrderSearchContext context);
    List<IBIZOrder> listEchartsDefaultDataSource(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchGaugeDataSource(IBIZOrderSearchContext context);
    List<IBIZOrder> listGaugeDataSource(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchGaugeDataSourceByTime(IBIZOrderSearchContext context);
    List<IBIZOrder> listGaugeDataSourceByTime(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchLogic22(IBIZOrderSearchContext context);
    List<IBIZOrder> listLogic22(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchRadarDataSource(IBIZOrderSearchContext context);
    List<IBIZOrder> listRadarDataSource(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchShzOrder(IBIZOrderSearchContext context);
    List<IBIZOrder> listShzOrder(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchState10(IBIZOrderSearchContext context);
    List<IBIZOrder> listState10(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchState30(IBIZOrderSearchContext context);
    List<IBIZOrder> listState30(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchState40(IBIZOrderSearchContext context);
    List<IBIZOrder> listState40(IBIZOrderSearchContext context);

    Page<IBIZOrder> searchXecx(IBIZOrderSearchContext context);
    List<IBIZOrder> listXecx(IBIZOrderSearchContext context);

    default IBIZOrderSearchContext getSearchContext() {
        return new IBIZOrderSearchContext();
    }
    List<IBIZOrder> selectByIbizCustomerId(String ibizCustomerId);
    boolean removeByIbizCustomerId(String ibizCustomerId);
    boolean resetByIbizCustomerId(String ibizCustomerId);
    boolean saveByIbizcustomer(cn.ibizlab.core.sample.domain.IBIZCustomer ibizCustomer,List<IBIZOrder> list);
    default boolean saveByIbizCustomerId(String ibizCustomerId,List<IBIZOrder> list) {
        cn.ibizlab.core.sample.domain.IBIZCustomer et = new cn.ibizlab.core.sample.domain.IBIZCustomer();
        et.setIbizCustomerId(ibizCustomerId);
        return getSelf().saveByIbizcustomer(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}