package cn.ibizlab.core.sample.service.logic.impl;

import java.util.Map;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieContainer;
import cn.ibizlab.core.sample.service.logic.IIBIZOrderDetailGetUnitAndPriceLogic;
import cn.ibizlab.core.sample.domain.IBIZOrderDetail;

/**
 * 关系型数据实体[GetUnitAndPrice] 对象
 */
@Slf4j
@Service
public class IBIZOrderDetailGetUnitAndPriceLogicImpl implements IIBIZOrderDetailGetUnitAndPriceLogic {

    @Autowired
    private KieContainer kieContainer;

    @Autowired
    private cn.ibizlab.core.sample.service.IIBIZUNIProductService ibizuniproductservice;

    public cn.ibizlab.core.sample.service.IIBIZUNIProductService getIbizuniproductService() {
        return this.ibizuniproductservice;
    }


    @Autowired
    private cn.ibizlab.core.sample.service.IIBIZOrderDetailService iBzSysDefaultService;

    public cn.ibizlab.core.sample.service.IIBIZOrderDetailService getIBzSysDefaultService() {
        return this.iBzSysDefaultService;
    }

    @Override
    public void execute(IBIZOrderDetail et) {

        KieSession kieSession = null;
        try {
            kieSession = kieContainer.newKieSession();
            cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizorderdetailgetunitandpriceproduct = new cn.ibizlab.core.sample.domain.IBIZUNIProduct();
            kieSession.insert(ibizorderdetailgetunitandpriceproduct); 
            kieSession.setGlobal("ibizorderdetailgetunitandpriceproduct", ibizorderdetailgetunitandpriceproduct);
            kieSession.insert(et); 
            kieSession.setGlobal("ibizorderdetailgetunitandpricedefault", et);
            kieSession.setGlobal("ibizuniproductservice", ibizuniproductservice);
            kieSession.setGlobal("iBzSysIbizorderdetailDefaultService", iBzSysDefaultService);
            kieSession.setGlobal("curuser", cn.ibizlab.util.security.AuthenticationUser.getAuthenticationUser());
            kieSession.startProcess("cn.ibizlab.core.sample.service.logic.ibizorderdetailgetunitandprice");

        } catch (Exception e) {
            throw new RuntimeException("执行[通过商品ID获取单价及单位]处理逻辑发生异常" + e);
        } finally {
            if(kieSession != null) {
                kieSession.destroy();
            }
        }
    }
}
