package cn.ibizlab.core.sample.service.logic.impl;

import java.util.Map;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieContainer;
import cn.ibizlab.core.sample.service.logic.IIBIZOrderDetailCountMoneyLogic;
import cn.ibizlab.core.sample.domain.IBIZOrderDetail;

/**
 * 关系型数据实体[CountMoney] 对象
 */
@Slf4j
@Service
public class IBIZOrderDetailCountMoneyLogicImpl implements IIBIZOrderDetailCountMoneyLogic {

    @Autowired
    private KieContainer kieContainer;


    @Autowired
    private cn.ibizlab.core.sample.service.IIBIZOrderDetailService iBzSysDefaultService;

    public cn.ibizlab.core.sample.service.IIBIZOrderDetailService getIBzSysDefaultService() {
        return this.iBzSysDefaultService;
    }

    @Override
    public void execute(IBIZOrderDetail et) {

        KieSession kieSession = null;
        try {
            kieSession = kieContainer.newKieSession();
            kieSession.insert(et); 
            kieSession.setGlobal("ibizorderdetailcountmoneydefault", et);
            kieSession.setGlobal("iBzSysIbizorderdetailDefaultService", iBzSysDefaultService);
            kieSession.setGlobal("curuser", cn.ibizlab.util.security.AuthenticationUser.getAuthenticationUser());
            kieSession.startProcess("cn.ibizlab.core.sample.service.logic.ibizorderdetailcountmoney");

        } catch (Exception e) {
            throw new RuntimeException("执行[统计金额]处理逻辑发生异常" + e);
        } finally {
            if(kieSession != null) {
                kieSession.destroy();
            }
        }
    }
}
