package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.filter.IBIZUNIProductSearchContext;
import cn.ibizlab.core.sample.service.IIBIZUNIProductService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZUNIProductMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[统一产品（索引主实体）] 服务对象接口实现
 */
@Slf4j
@Service("IBIZUNIProductServiceImpl")
public class IBIZUNIProductServiceImpl extends ServiceImpl<IBIZUNIProductMapper, IBIZUNIProduct> implements IIBIZUNIProductService {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZOrderDetailService ibizorderdetailService;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0011Service ibizsample0011Service;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0013Service ibizsample0013Service;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZUNIProduct et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizuniproductid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZUNIProduct> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZUNIProduct et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizuniproductid", et.getIbizuniproductid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizuniproductid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZUNIProduct> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        if(!ObjectUtils.isEmpty(ibizorderdetailService.selectByIbizuniproductid(key)))
            throw new BadRequestAlertException("删除数据失败，当前数据存在关系实体[IBIZOrderDetail]数据，无法删除!","","");
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        if(!ObjectUtils.isEmpty(ibizorderdetailService.selectByIbizuniproductid(idList)))
            throw new BadRequestAlertException("删除数据失败，当前数据存在关系实体[IBIZOrderDetail]数据，无法删除!","","");
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZUNIProduct get(String key) {
        IBIZUNIProduct et = getById(key);
        if(et == null){
            et = new IBIZUNIProduct();
            et.setIbizuniproductid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZUNIProduct getDraft(IBIZUNIProduct et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZUNIProduct et) {
        return (!ObjectUtils.isEmpty(et.getIbizuniproductid())) && (!Objects.isNull(this.getById(et.getIbizuniproductid())));
    }
    @Override
    @Transactional
    public boolean save(IBIZUNIProduct et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZUNIProduct et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZUNIProduct> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZUNIProduct> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZUNIProduct> searchDefault(IBIZUNIProductSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZUNIProduct> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZUNIProduct>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }

    /**
     * 查询集合 IndexDER
     */
    @Override
    public Page<IBIZUNIProduct> searchIndexDER(IBIZUNIProductSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZUNIProduct> pages=baseMapper.searchIndexDER(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZUNIProduct>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZUNIProduct> getIbizuniproductByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZUNIProduct> getIbizuniproductByEntities(List<IBIZUNIProduct> entities) {
        List ids =new ArrayList();
        for(IBIZUNIProduct entity : entities){
            Serializable id=entity.getIbizuniproductid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



