package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZStorage;
import cn.ibizlab.core.sample.filter.IBIZStorageSearchContext;
import cn.ibizlab.core.sample.service.IIBIZStorageService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZStorageMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[存储] 服务对象接口实现
 */
@Slf4j
@Service("IBIZStorageServiceImpl")
public class IBIZStorageServiceImpl extends ServiceImpl<IBIZStorageMapper, IBIZStorage> implements IIBIZStorageService {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZStorage et) {
        createIndexMajorEntityData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizstorageid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZStorage> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZStorage et) {
        ibizhardwareService.update(ibizstorageInheritMapping.toIbizhardware(et));
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizstorageid", et.getIbizstorageid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizstorageid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZStorage> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        ibizhardwareService.remove(key);
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZStorage get(String key) {
        IBIZStorage et = getById(key);
        if(et == null){
            et = new IBIZStorage();
            et.setIbizstorageid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZStorage getDraft(IBIZStorage et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZStorage et) {
        return (!ObjectUtils.isEmpty(et.getIbizstorageid())) && (!Objects.isNull(this.getById(et.getIbizstorageid())));
    }
    @Override
    @Transactional
    public boolean save(IBIZStorage et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZStorage et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZStorage> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZStorage> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZStorage> searchDefault(IBIZStorageSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZStorage> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZStorage>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }






    @Autowired
    cn.ibizlab.core.sample.mapping.IBIZStorageInheritMapping ibizstorageInheritMapping;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZHardwareService ibizhardwareService;

    /**
     * 创建索引主实体数据
     * @param et
     */
    private void createIndexMajorEntityData(IBIZStorage et){
        if(ObjectUtils.isEmpty(et.getIbizstorageid()))
            et.setIbizstorageid((String)et.getDefaultKey(true));
        cn.ibizlab.core.sample.domain.IBIZHardware ibizhardware =ibizstorageInheritMapping.toIbizhardware(et);
        ibizhardware.set("ibizhardwaretype","Storage");
        ibizhardwareService.create(ibizhardware);
    }

    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZStorage> getIbizstorageByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZStorage> getIbizstorageByEntities(List<IBIZStorage> entities) {
        List ids =new ArrayList();
        for(IBIZStorage entity : entities){
            Serializable id=entity.getIbizstorageid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



