package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.filter.IBIZSoftwareSuitSearchContext;
import cn.ibizlab.core.sample.service.IIBIZSoftwareSuitService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSoftwareSuitMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[软件] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSoftwareSuitServiceImpl")
public class IBIZSoftwareSuitServiceImpl extends ServiceImpl<IBIZSoftwareSuitMapper, IBIZSoftwareSuit> implements IIBIZSoftwareSuitService {


    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSoftwareSuit et) {
        createIndexMajorEntityData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsoftwaresuitid()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSoftwareSuit> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSoftwareSuit et) {
        ibizuniproductService.update(ibizsoftwaresuitInheritMapping.toIbizuniproduct(et));
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsoftwaresuitid", et.getIbizsoftwaresuitid()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsoftwaresuitid()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSoftwareSuit> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        ibizuniproductService.remove(key);
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSoftwareSuit get(String key) {
        IBIZSoftwareSuit et = getById(key);
        if(et == null){
            et = new IBIZSoftwareSuit();
            et.setIbizsoftwaresuitid(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSoftwareSuit getDraft(IBIZSoftwareSuit et) {
        return et;
    }

    @Override
    public boolean checkKey(IBIZSoftwareSuit et) {
        return (!ObjectUtils.isEmpty(et.getIbizsoftwaresuitid())) && (!Objects.isNull(this.getById(et.getIbizsoftwaresuitid())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSoftwareSuit et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSoftwareSuit et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSoftwareSuit> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSoftwareSuit> list) {
        saveOrUpdateBatch(list,batchSize);
    }



    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSoftwareSuit> searchDefault(IBIZSoftwareSuitSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSoftwareSuit> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSoftwareSuit>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }






    @Autowired
    cn.ibizlab.core.sample.mapping.IBIZSoftwareSuitInheritMapping ibizsoftwaresuitInheritMapping;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZUNIProductService ibizuniproductService;

    /**
     * 创建索引主实体数据
     * @param et
     */
    private void createIndexMajorEntityData(IBIZSoftwareSuit et){
        if(ObjectUtils.isEmpty(et.getIbizsoftwaresuitid()))
            et.setIbizsoftwaresuitid((String)et.getDefaultKey(true));
        cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizuniproduct =ibizsoftwaresuitInheritMapping.toIbizuniproduct(et);
        ibizuniproduct.set("ibizuniproducttype","Software");
        ibizuniproductService.create(ibizuniproduct);
    }

    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSoftwareSuit> getIbizsoftwaresuitByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSoftwareSuit> getIbizsoftwaresuitByEntities(List<IBIZSoftwareSuit> entities) {
        List ids =new ArrayList();
        for(IBIZSoftwareSuit entity : entities){
            Serializable id=entity.getIbizsoftwaresuitid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



