package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0020;
import cn.ibizlab.core.sample.filter.IBIZSample0020SearchContext;
import cn.ibizlab.core.sample.service.IIBIZSample0020Service;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSample0020Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[员工] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0020ServiceImpl")
public class IBIZSample0020ServiceImpl extends ServiceImpl<IBIZSample0020Mapper, IBIZSample0020> implements IIBIZSample0020Service {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0019Service ibizsample0019Service;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSample0020 et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0020id()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSample0020> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSample0020 et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsample0020id", et.getIbizsample0020id()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0020id()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSample0020> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSample0020 get(String key) {
        IBIZSample0020 et = getById(key);
        if(et == null){
            et = new IBIZSample0020();
            et.setIbizsample0020id(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSample0020 getDraft(IBIZSample0020 et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(IBIZSample0020 et) {
        return (!ObjectUtils.isEmpty(et.getIbizsample0020id())) && (!Objects.isNull(this.getById(et.getIbizsample0020id())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSample0020 et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSample0020 et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSample0020> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSample0020> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<IBIZSample0020> selectByIbizsample0019id(String ibizsample0019id) {
        return baseMapper.selectByIbizsample0019id(ibizsample0019id);
    }
    @Override
    public void removeByIbizsample0019id(String ibizsample0019id) {
        this.remove(new QueryWrapper<IBIZSample0020>().eq("ibizsample0019id",ibizsample0019id));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSample0020> searchDefault(IBIZSample0020SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0020> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0020>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(IBIZSample0020 et){
        //实体关系[DER1N_IBIZSAMPLE0020_IBIZSAMPLE0019_IBIZSAMPLE0019ID]
        if(!ObjectUtils.isEmpty(et.getIbizsample0019id())){
            cn.ibizlab.core.sample.domain.IBIZSample0019 ibizsample0019=et.getIbizsample0019();
            if(ObjectUtils.isEmpty(ibizsample0019)){
                cn.ibizlab.core.sample.domain.IBIZSample0019 majorEntity=ibizsample0019Service.get(et.getIbizsample0019id());
                et.setIbizsample0019(majorEntity);
                ibizsample0019=majorEntity;
            }
            et.setIbizsample0019name(ibizsample0019.getIbizsample0019name());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSample0020> getIbizsample0020ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSample0020> getIbizsample0020ByEntities(List<IBIZSample0020> entities) {
        List ids =new ArrayList();
        for(IBIZSample0020 entity : entities){
            Serializable id=entity.getIbizsample0020id();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



