package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0016;
import cn.ibizlab.core.sample.filter.IBIZSample0016SearchContext;
import cn.ibizlab.core.sample.service.IIBIZSample0016Service;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSample0016Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[项目成员] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0016ServiceImpl")
public class IBIZSample0016ServiceImpl extends ServiceImpl<IBIZSample0016Mapper, IBIZSample0016> implements IIBIZSample0016Service {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0014Service ibizsample0014Service;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0015Service ibizsample0015Service;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSample0016 et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0016id()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSample0016> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSample0016 et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsample0016id", et.getIbizsample0016id()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0016id()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSample0016> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSample0016 get(String key) {
        IBIZSample0016 et = getById(key);
        if(et == null){
            et = new IBIZSample0016();
            et.setIbizsample0016id(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSample0016 getDraft(IBIZSample0016 et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(IBIZSample0016 et) {
        return (!ObjectUtils.isEmpty(et.getIbizsample0016id())) && (!Objects.isNull(this.getById(et.getIbizsample0016id())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSample0016 et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSample0016 et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSample0016> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSample0016> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<IBIZSample0016> selectByIbizsample0014id(String ibizsample0014id) {
        return baseMapper.selectByIbizsample0014id(ibizsample0014id);
    }
    @Override
    public void resetByIbizsample0014id(String ibizsample0014id) {
        this.update(new UpdateWrapper<IBIZSample0016>().set("ibizsample0014id",null).eq("ibizsample0014id",ibizsample0014id));
    }

    @Override
    public void resetByIbizsample0014id(Collection<String> ids) {
        this.update(new UpdateWrapper<IBIZSample0016>().set("ibizsample0014id",null).in("ibizsample0014id",ids));
    }

    @Override
    public void removeByIbizsample0014id(String ibizsample0014id) {
        this.remove(new QueryWrapper<IBIZSample0016>().eq("ibizsample0014id",ibizsample0014id));
    }

	@Override
    public List<IBIZSample0016> selectByIbizsample0015id(String ibizsample0015id) {
        return baseMapper.selectByIbizsample0015id(ibizsample0015id);
    }
    @Override
    public void removeByIbizsample0015id(String ibizsample0015id) {
        this.remove(new QueryWrapper<IBIZSample0016>().eq("ibizsample0015id",ibizsample0015id));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSample0016> searchDefault(IBIZSample0016SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0016> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0016>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(IBIZSample0016 et){
        //实体关系[DER1N_IBIZSAMPLE0016_IBIZSAMPLE0014_IBIZSAMPLE0014ID]
        if(!ObjectUtils.isEmpty(et.getIbizsample0014id())){
            cn.ibizlab.core.sample.domain.IBIZSample0014 ibizsample0014=et.getIbizsample0014();
            if(ObjectUtils.isEmpty(ibizsample0014)){
                cn.ibizlab.core.sample.domain.IBIZSample0014 majorEntity=ibizsample0014Service.get(et.getIbizsample0014id());
                et.setIbizsample0014(majorEntity);
                ibizsample0014=majorEntity;
            }
            et.setIbizsample0014name(ibizsample0014.getIbizsample0014name());
        }
        //实体关系[DER1N_IBIZSAMPLE0016_IBIZSAMPLE0015_IBIZSAMPLE0015ID]
        if(!ObjectUtils.isEmpty(et.getIbizsample0015id())){
            cn.ibizlab.core.sample.domain.IBIZSample0015 ibizsample0015=et.getIbizsample0015();
            if(ObjectUtils.isEmpty(ibizsample0015)){
                cn.ibizlab.core.sample.domain.IBIZSample0015 majorEntity=ibizsample0015Service.get(et.getIbizsample0015id());
                et.setIbizsample0015(majorEntity);
                ibizsample0015=majorEntity;
            }
            et.setIbizsample0015name(ibizsample0015.getIbizsample0015name());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSample0016> getIbizsample0016ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSample0016> getIbizsample0016ByEntities(List<IBIZSample0016> entities) {
        List ids =new ArrayList();
        for(IBIZSample0016 entity : entities){
            Serializable id=entity.getIbizsample0016id();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



